library("fpc")
library("microbenchmark")

files <- list.files("../datasets/")
n <- length(files)
timing <- data.frame(dbscan = numeric(n),
  optics = numeric(n))
rownames(timing) <- files

for (file in files){
  print(paste("Doing", file))
  bench_data <- read.csv(paste0("../datasets/", file), header = F)
  times <- microbenchmark::microbenchmark(
    fpc::dbscan(data = bench_data,
                eps = 0.10, MinPts = 2), times = 15, control=list(warmup=4))
  timing[file, "dbscan"] <- (mean(times$time/1e6))
}

write.csv(timing, file = "timings.csv")
