## ---- PyClustering DBSCAN Benchmark ----

import timeit
from os import listdir
import sys

# Get file names to benchmark
data_files = [f for f in listdir("../datasets/")]

print('"","dbscan","optics"')

## NOTE: PyClustering reports that through the option `ccore=True` a faster C implementation can be used
## to run DBSCAN, however all data sets tested in this benchmark were unable to be processed by the CCORE library,
## presumably due to errors in the implementation. Thus, ccore is set to 'False.'
for file in data_files:
    pycl_DBSCAN ='''
import pandas as pd
from pyclustering.cluster.dbscan import dbscan
data_dir = "../datasets/"
d3 = pd.read_csv(data_dir +"'''+file+'''")
d3_list = d3.values.tolist()
res = dbscan(d3_list, 0.10, 2, False)
'''

    pycl_OPTICS = '''
import os
import pandas as pd
from pyclustering.cluster.dbscan import dbscan
from pyclustering.cluster.optics import optics
data_dir = "../datasets/"
d3 = pd.read_csv(data_dir +"'''+file+'''")
d3_list = d3.values.tolist()
res = optics(d3_list, float("inf"), 2)
'''
    ## Print time to process in milliseconds
    print('"' + file + '"' 
    + "," 
    + str((timeit.timeit("res.process()", setup=pycl_DBSCAN, number=15)/15)*1000) 
    + "," 
    + str((timeit.timeit("res.process()", setup=pycl_OPTICS, number=15)/15) * 1000))
    sys.stdout.flush()
