import java.io.File;
import java.util.List;
import ca.pfv.spmf.patterns.cluster.Cluster;
import ca.pfv.spmf.algorithms.clustering.dbscan.*;
import ca.pfv.spmf.algorithms.clustering.optics.*;

public class SPMF {

	public static void main(String[] args) throws Exception {

		// Number of benchmarks to run
		int n_bench = 15;

		// SPMF
		int minPts = 2;

		// comma separated
		String separator = ",";

		System.out.println("\"\",\"dbscan\", \"optics\"");

		// DBSCAN
		AlgoDBSCAN dbsc = new AlgoDBSCAN();
		AlgoOPTICS algo = new AlgoOPTICS();
		List<DoubleArrayOPTICS> clusterOrdering;


		File folder = new File("../datasets/");
		File[] listOfFiles = folder.listFiles();
		for (int f_i = 0; f_i < listOfFiles.length; ++f_i) {
			System.out.print("\"" + listOfFiles[f_i] + "\"");
			String benchmark_file = listOfFiles[f_i].toString();

			// For dbscan
			double epsilon = 0.1;

			double avg_time = 0;
			for (int i = 0; i < n_bench; ++i) {
				long startTime = System.currentTimeMillis();
				List<Cluster> clusters = dbsc.runAlgorithm(benchmark_file, minPts, epsilon, separator);
				double endTime = System.currentTimeMillis();
				avg_time += (endTime - startTime);

			}
			System.out.print("," + (avg_time / n_bench));

			// Update parameters of OPTICS:
			epsilon = 1;

			avg_time = 0.0;
			for (int i = 0; i < n_bench; ++i) {
				double startTime = System.currentTimeMillis();
				clusterOrdering = algo.computerClusterOrdering(benchmark_file, minPts, epsilon, separator);
				double endTime = System.currentTimeMillis();
				avg_time += (endTime - startTime);
			}
			System.out.println("," + (avg_time / n_bench));
		}
	}
}
