## ---- SciKit Learn DBSCAN Benchmark ----

import timeit
from os import listdir

# Get file names to benchmark
data_files = [f for f in listdir("../datasets/")]

print('"","dbscan","optics"')

# Benchmark DBSCAN
for file in data_files:
    scikit_DBSCAN = '''
import numpy as np
from sklearn.cluster import DBSCAN
from sklearn import metrics
from sklearn.datasets.samples_generator import make_blobs
from sklearn.preprocessing import StandardScaler
import os
import pandas as pd
data_dir = "../datasets/"
d3 = pd.read_csv(data_dir + "'''+file+'''")'''
    print('"' + file + '",'
    + str((timeit.timeit("DBSCAN(eps=0.1, min_samples=2).fit(d3)", setup=scikit_DBSCAN, number=15)/15)*1000))
