import weka.core.Instances;
import weka.clusterers.DBSCAN;
import weka.clusterers.OPTICS;
import weka.core.converters.ConverterUtils.DataSource;

import java.io.File;


public class WEKA {

	public static void main(String[] args) throws Exception {
		DBSCAN dbscan;
		OPTICS optics;
		int n_tests = 15;
		System.out.println("\"\",\"dbscan\", \"optics\"");

		File folder = new File("../datasets/");
		File[] listOfFiles = folder.listFiles();
		for (int f_i = 0; f_i < listOfFiles.length; ++f_i) {
			System.out.print("\"" + listOfFiles[f_i] + "\"");
			String benchmark_file = listOfFiles[f_i].toString();

			// I/O
			DataSource source = new DataSource(benchmark_file);
			Instances data = source.getDataSet();

			// DBSCAN
			dbscan = new DBSCAN();
			dbscan.setMinPoints(2);
			dbscan.setEpsilon(0.10);

			double avg_time = 0;
			for (int i = 0; i < n_tests; ++i) {
				long startTime = System.currentTimeMillis();
				dbscan.buildClusterer(data);
				long endTime = System.currentTimeMillis();
				avg_time += (endTime - startTime);
			}
			System.out.print("," + avg_time/n_tests);

			// OPTICS
			optics = new OPTICS();
			optics.setMinPoints(2);
			optics.setEpsilon(1.0);
			optics.setShowGUI(false);

			avg_time = 0;
			for (int i = 0; i < n_tests; ++i) {
				long startTime = System.currentTimeMillis();
				optics.buildClusterer(data);
				long endTime = System.currentTimeMillis();
				avg_time += (endTime - startTime);
			}
			System.out.println("," + avg_time/n_tests);
		}
	}
}
