# This code aggregates the timing information produced via the make

benchmarks <- c(
  "dbscan",
  "ELKI",
  "FPC",
  "PyClustering",
  "SciKit",
  "SPMF",
  "WEKA"
)

optics <- list()
dbscan <- list()


for(b in benchmarks) {
  dat <- try(timing <- read.csv(paste0(b,"/timings.csv")), silent = TRUE)
  if(inherits(dat, "try-error")) {
    warning("Timing information for ", b, " missing. See readme file to
            installe the appropriate software and run the benchmark.")
    next
  } else{
    
    ds <- as.character(dat[[1]])  
    ds <- gsub(".*/", "", ds)  
    ds <- gsub("\\.csv", "", ds)  
    o <- order(ds)
  }
  
  dbscan[[b]] <- dat[[2]][o]
  names(dbscan[[b]]) <- ds[o]
  
  optics[[b]] <- dat[[3]][o]
  names(optics[[b]]) <- ds[o]
  
  
}

# Create plot for DBSCAN
dbscan <- do.call(cbind, dbscan)

row.ord <- c("pathbased", "spiral", "flame", "jain", "Compound", "R15",
             "Aggregation",  "synth2_10d", "synth1_3d","synth3_100d",
             "D31", "s1", "s4", "t4.8k")

dbscan <- dbscan[row.ord, order(colMeans(dbscan))]

oldpar <- par(mar = c(7,4,4,2) + .1)
matplot(dbscan, type = "l", log= "y", 
        axes = FALSE, ylab  = "Time (ms)",
        main = "DBSCAN Benchmark",
        lty = 1, col = 1:ncol(dbscan))
legend("bottomright", legend = colnames(dbscan), lty = 1, col= 1:ncol(dbscan),
       title = "Library")
axis(1, at = 1:nrow(dbscan), labels = rownames(dbscan), las = 2)  
axis(2)
box()

# Create plot for OPTICS
optics <- do.call(cbind, optics)
optics <- optics[,(colSums(optics) > 0) & !is.na(colSums(optics))]
optics <- optics[row.ord, order(colMeans(optics))]

matplot(optics, type = "l", log= "y", axes = FALSE, 
        main = "OPTICS Benchmark", lty = 1, col = 1:ncol(optics))
legend("bottomright", legend = colnames(optics), lty = 1, col= 1:ncol(optics),
       title = "Library")
axis(1, at = 1:nrow(optics), labels = rownames(optics), las = 2)  
axis(2)
box()

par(oldpar)

