library("dbscan")
library("microbenchmark")

files <- list.files("../datasets/")
n <- length(files)
timing <- data.frame(dbscan = numeric(n),
		     optics = numeric(n))
rownames(timing) <- files

for (file in files){
  print(paste("Doing", file))
  bench_data <- read.csv(paste0("../datasets/", file), header = F)
  db_times <- microbenchmark::microbenchmark(
    dbscan::dbscan(bench_data, eps = 0.10, minPts = 2), times = 15, control=list(warmup=4))
  optics_times <- microbenchmark::microbenchmark(
    dbscan::optics(bench_data, eps = 1.0, minPts = 2), times = 15, control=list(warmup=4))
  timing[file, "dbscan"] <- (mean(db_times$time/1e6))
  timing[file, "optics"] <- mean(optics_times$time/1e6)
}

write.csv(timing, file = "timings.csv")
