## Code to generate synthetic datasets for benchmarking
set.seed(665544)
n <- 1000
dim <- c(3, 10, 100)
normalize <- function(x) (x - min(x)) / (max(x) - min(x))

## First data set: 3 dimensional 
x1 <- replicate(dim[1], runif(10, 0, 10) + rnorm(n, sd = 0.2))
x1 <- apply(x1, 2, normalize)
write.csv(x1, "datasets/synth1_3d.csv", col.names = FALSE)

## Second data set: 10 dimensional 
x2 <- replicate(dim[2], runif(10, 0, 10) + rnorm(n, sd = 0.2))
x2 <- apply(x2, 2, normalize)
write.csv(x2, "datasets/synth2_10d.csv", col.names = FALSE)

## Third data set: 100 dimensional 
x3 <- replicate(dim[3], runif(10, 0, 10) + rnorm(n, sd = 0.2))
x3 <- apply(x3, 2, normalize)
write.csv(x3, "datasets/synth3_100d.csv", col.names = FALSE)


