import numpy as np
import json
import pandas as pd

import matplotlib.pyplot as plt
import seaborn as sns

sns.set()

with open('simulationlog_bts.json') as file:
    data = json.load(file)

data = data[0]

data_returning = []
data_new = []

length = len(data)

for i in range(length):
    temp_data = data[str(i)]
    if temp_data["context"]["customer"] == "returning":
        data_returning.append(temp_data["action"]["price"])
    else:
        data_new.append(temp_data["action"]["price"])

fig = plt.figure(1)
ax = fig.add_subplot(111)

handle1 = ax.plot(list(range(len(data_returning))), data_returning)#, color=sns.xkcd_rgb["windows blue"])
handle2 = ax.plot(list(range(len(data_new))), data_new)#, color=sns.xkcd_rgb["faded green"])

plt.ylabel("Price")
plt.xlabel("Interactions")
plt.legend(('Returning customer', 'New customer'))
plt.show()

fig.savefig('bts_graphic.pdf', format='pdf')
