#### Nile example modified from packages dlm and FKF
## This file is to be source()d

library("FKF")
library("nimble")
library("nimbleSMC")

set.seed(seed)

y <- Nile

code <- nimbleCode({
  for (t in 1:n)
    y[t] ~ dnorm(x[t], sd = sigmaMeasurements)
  x[1] ~ dnorm(a0, sd = sigmaInnovations)    
  for (t in 2:n)
    x[t] ~ dnorm((t-1==28)*meanShift1899 + x[t - 1], sd = sigmaInnovations)
  logSigmaInnovations ~ dnorm(0, sd = 100)
  logSigmaMeasurements ~ dnorm(0, sd = 100)
  sigmaInnovations <- exp(logSigmaInnovations)
  sigmaMeasurements <- exp(logSigmaMeasurements)
  a0 ~ dnorm(1120, var = 100)
  meanShift1899 ~ dnorm(0, sd = 100)
})

if(!exists("inits"))
  inits <- list(logSigmaInnovations = log(sd(y)),
                logSigmaMeasurements = log(sd(y)),
                meanShift1899 = 0)

m <- nimbleModel(code, data = list(y = Nile),
                 constants = list(n = length(y)),
                 inits = inits)

if(!exists("perturbThetaSD")) perturbThetaSD <- c(2, 2, 5)
if(!exists("initParamSigma")) initParamSigma <- c(2, 2, 5)

ff <- buildIteratedFilter2(model = m, nodes = "x",
                           params = c("logSigmaInnovations",
                                      "logSigmaMeasurements",
                                      "meanShift1899"),
                           baselineNode = "a0",
                           control = list(sigma = perturbThetaSD,
                                          initParamSigma = initParamSigma))
cm <- compileNimble(m)
cff  <- compileNimble(ff, project = m)

if (!exists("numParticles")) numParticles <- 1000
if (!exists("numPFruns")) numPFruns <- 100
if (!exists("alpha")) alpha <- 0.2

runtime <- system.time(est <- cff$run(m = numParticles,
                                      niter = numPFruns,
                                      alpha = alpha))

## Calculate correct likelihood by Kalman Filter in FKF
dtpred <- matrix(0, ncol = length(y))
dtpred[28] <- est[3]
ct <- matrix(0)
Zt <- Tt <- matrix(1)

fkfLogLik <- fkf(HHt = matrix(exp(2*est[1])),
                 GGt = matrix(exp(2*est[2])),
                 yt = rbind(y),
                 a0 = 1120,
                 P0 = matrix(100),
                 dt = dtpred, ct = ct, Zt = Zt, Tt = Tt)$logLik
