
SVexample_run_replicate <- function(rep_label, ## We use rep_labels of "a" through "j"
                                    N,         ## This is M, number of particles
                                    sdFactor,  ## This is h, multiplier of perturbation std. dev'
                                    seed,
                                    niter = 50000) { 
  
  ## For readability, we write R code to a file rather than
  ## saving data to a file.
  configfile <- paste0("SVexample_config_rep_", rep_label, "_", seed, ".R")
  zz <- file(configfile, open = "wt")
  writeLines(paste0("covSDs <- ", sdFactor," * c(0.089, 0.039, 1.45)"), con = zz)
  writeLines(paste0("N <- ", N), con = zz)
  writeLines(paste0("m <- ", niter), con = zz)
  writeLines(paste0("seed <- ", seed), con = zz)
  writeLines(paste0("outputfile <- \"SVexample_output_rep_",
                    rep_label, "_", seed, ".RDS\""), con = zz)
  close(zz)
  system(paste0("Rscript ./SVexample_setup_and_run_one_case.R ", configfile))
}
