
IF2example_run_all_cases <- function(param_combinations_df, label = "") {
  if (label != "")
    label <- paste0(label, "_")
  
  ## We write code into a file for readability rather
  ## than saving a data file.
  for (i_row in 1:nrow(param_combinations_df)) {
    im <- param_combinations_df[i_row, "m"]
    iAlpha <- param_combinations_df[i_row, "alpha"]
    iNiter <- param_combinations_df[i_row, "niter"]
    iSeed <- param_combinations_df[i_row, "seed"]
    
    configfile <- paste0("IF2example_config_", label, "_", iSeed, ".R")
    zz <- file(configfile, open = "wt")
    writeLines(paste0("numParticles <- ", im), con = zz)
    writeLines(paste0("numPFruns <- ", iNiter), con = zz)
    writeLines(paste0("alpha <- ",
                      iAlpha ), con = zz)
    writeLines(paste0("perturbThetaSD <- c(0.1, 0.1, 5)"), con = zz)
    writeLines(paste0("initParamSigma <- c(0.1, 0.1, 5)"), con = zz)
    writeLines(paste0("inits <- list(logSigmaInnovations = 5.131244, logSigmaMeasurements = 5.131244, meanShift1899 = -100)"),
               con = zz)
    writeLines(paste0("seed <- ", iSeed), con = zz)
    writeLines(paste0("outputfile <- \"IF2example_output_",
                      label, "_", iSeed, ".RDS\""), con = zz)
    close(zz)
    system(paste0("Rscript ./IF2example_setup_and_run_one_case.R ", configfile))
  }
}

m <- c(100, 200, 500, 1000, 2000)
alpha <- c(0.1, 0.2, 0.4, 0.6)
niter <- 2 * c(500, 250, 100, 50, 25) ## doubled from v9
param_combinations <- expand.grid(m, alpha, niter) ## Create a df with all combinations of parameters
colnames(param_combinations) <- c("m", "alpha", "niter")
param_combinations$seed <- 1:nrow(param_combinations)

IF2example_run_all_cases(param_combinations, label = "final")
