library("ggplot2")

rep_label <- "a"

iCase <- 1
MCMCresults <- list()
for(seed in c(11, 14)) { ## m = 25 or 100. h = 1.
  resultsfile <- (paste0("SVexample_output_rep_", rep_label, "_", seed, ".RDS"))
  MCMCresults[[iCase]] <- readRDS(resultsfile)
  iCase <- iCase + 1
}

params <- c("mu", "phi", "sigma")
nParams <- length(params)
N <- numeric()
h <- numeric()
sample <- numeric()
Param <- character()
iteration = integer()

for (iCase in seq_along(MCMCresults)) {
  for (iParam in 1:nParams) {
    newLen <- length(MCMCresults[[iCase]]$samples[, params[iParam]])
    sample <- append(sample, MCMCresults[[iCase]]$samples[, params[iParam]])
    N <- append(N, rep(MCMCresults[[iCase]]$N, newLen))
    h <- append(h, rep(MCMCresults[[iCase]]$covSDs[1] / 0.089, newLen))
    Param <- append(Param, rep(params[iParam], newLen))
    iteration <- append(iteration, 1:newLen)
  }
}

MCMCsamples <- data.frame(sample = sample, N = factor(N), h = h, Param = Param,
                          iteration = iteration)

levels(MCMCsamples$N) <- c("M = 25", "M = 100")

PMCMCtraceplot <- ggplot(data = subset(MCMCsamples, iteration > 10000 & iteration <= 20000),
                         aes(x = iteration, y = sample)) +
  geom_line() + facet_grid(Param ~ N, scales = "free_y")


## View figure directly
PMCMCtraceplot

## Save figure.
# ggsave(plot = PMCMCtraceplot, filename = "./../../Figures/PMCMCtraceplot.pdf", device = "pdf") 
