# This illustrates creation of 10 replicates running in serial.
# One can modify for distributed computing.
library("parallel")
set.seed(1)

source("SVexample_run_replicate.R")

N <- seq(25, 125, by = 25)            ## This is M, number of particles
sdFactors <- seq(0.5, 1.5, by = 0.25) ## This is h, multiplier of perturbation std. dev's
rep_labels <- letters[1:10]

param_combinations <- expand.grid(N, sdFactors, rep_labels) ## Create a df with all combinations of parameters
colnames(param_combinations) <- c("N", "sdFactors", "rep_labels")
param_combinations$seed <- 1:nrow(param_combinations)
niter <- 50000

mclapply(1:nrow(param_combinations), function(i_row) {
  i_N <- param_combinations$N[i_row]
  i_sdFactor <- param_combinations$sdFactors[i_row]
  i_rep_label <- param_combinations$rep_labels[i_row]
  i_seed <- param_combinations$seed[i_row]
  
  SVexample_run_replicate(i_rep_label, i_N, i_sdFactor, i_seed, niter)
  return(NULL)
}, mc.cores = 10)
