label <- "final"
library("FKF")
library("ggplot2")
y <- Nile
calcFkfLogLik <- function(est) {
  dtpred <- matrix(0, ncol = length(y))
  dtpred[28] <- est[3]
  ct <- matrix(0)
  Zt <- Tt <- matrix(1)
  
  fkfLogLik <- fkf(HHt = matrix(exp(2 * est[1])),
                   GGt = matrix(exp(2 * est[2])),
                   yt = rbind(y),
                   a0 = 1120,
                   P0 = matrix(100),
                   dt = dtpred, ct = ct, Zt = Zt, Tt = Tt)$logLik
  fkfLogLik
}

fkf.mle <- optim(c(log(sd(y)), log(sd(y)), -200), calcFkfLogLik,
                 control = list(fnscale = -1))

outputfilebase <-  paste0("IF2example_output_",label, "*.RDS")
files <- Sys.glob(outputfilebase)
resultList <- list()
for (iF in seq_along(files)) {
  resultList[[iF]] <- readRDS(files[iF])
  resultList[[iF]]$fkfLogLikVec <- apply(resultList[[iF]]$estimates,
                                         1,
                                         calcFkfLogLik)
}

numParticles <- numeric()
numPFruns <- numeric()
alpha <- numeric()
FkfLogLik <- numeric()
iteration <- numeric()
time <- numeric()
MLE <- numeric()

## plot of logLiks
for (iR in seq_along(resultList)) {
  n <- length(resultList[[iR]]$fkfLogLikVec)
  ## numParticles <- append(numParticles, rep(resultList[[iR]]$numParticles, n))
  ## numPFruns <- append(numPFruns, rep(resultList[[iR]]$numPFruns, n))
  ## perturbationReductionFactor <- append(perturbationReductionFactor,
  ##                                       rep(resultList[[iR]]$perturbationReductionFactor, n))
  numParticles <- append(numParticles, rep(resultList[[iR]]$numParticles, n))
  numPFruns <- append(numPFruns, rep(n, n))
  alpha <- append(alpha, rep(resultList[[iR]]$alpha, n))
  FkfLogLik <- append(FkfLogLik, resultList[[iR]]$fkfLogLikVec)
  iteration <- append(iteration, 1:n)
  time <- append(time, sum(resultList[[iR]]$runtime[1:2]) * (1:n) / n)
  MLE <- append(MLE, rep(fkf.mle$value, n))
}

FkfLogLikResults <- data.frame(numParticles = factor(numParticles),
                               numPFruns,
                               alpha = factor(alpha),
                               FkfLogLik,
                               iteration,
                               time,
                               MLE = MLE)

levels(FkfLogLikResults$numParticles) <- paste0("M = ", sort(unique(numParticles)))

resultplot <- ggplot(aes(x = iteration, y = FkfLogLik),
                     data = FkfLogLikResults) %+%
  geom_line(aes(color = alpha), alpha = 0.5) + ylim(c(-635, -626)) +
  facet_wrap(. ~ numParticles, scales = "free_x") +
  geom_line(aes(x = iteration, y = MLE)) + theme_minimal() +
  ylab("Log likelihood")

## View figure directly
resultplot

## Save figure
# ggsave(plot = resultplot, file = paste0("./../../Figures/IF2exampleFigure_",
#   label, ".pdf"), device = "pdf")
