dir <- "."

train <- read.csv(file.path(dir, "mnist_train.csv"), header = FALSE)
y <- train[, 1]
xi <- train[, -1]
nsample <- NROW(xi)
npixel <- NCOL(xi)
xi <- matrix(as.integer(xi > 255/2), nrow = nsample, ncol = npixel)
dat <- cbind(data.frame(y = y), data.frame(xi))
saveRDS(dat, file = "mnist_train_binary.rds")

test <- read.csv(file.path(dir, "mnist_test.csv"), header = FALSE)
y <- test[, 1]
xi <- test[, -1]
nsample <- NROW(xi)
npixel <- NCOL(xi)
xi <- matrix(as.integer(xi > 255/2), nrow = nsample, ncol = npixel)
dat <- cbind(data.frame(y = y), data.frame(xi))
saveRDS(dat, file = "mnist_test_binary.rds")
