
#include <stdlib.h>

typedef struct {
  unsigned n;
  unsigned* nag;
  double* val;
} isoreg;

void mdpava( double* vect, int *n )
{
  isoreg* fit = malloc( sizeof( isoreg ) );
  unsigned* nag = malloc( *n * sizeof( unsigned ) );
  double* val = malloc( *n * sizeof( double ) );
  unsigned i, j, k;
  nag[0] = 1;
  val[0] = vect[0];
  j = 0;
  for ( i = 1; i < *n; i++ ) {
    j += 1;
    val[j] = vect[i];
    nag[j] = 1;
    while ( ( j > 0 ) && ( val[j] < val[j - 1] ) ) {
      val[j - 1] = ( nag[j] * val[j] + nag[j - 1] * val[j - 1] ) / ( nag[j] + nag[j - 1] );
      nag[j - 1] += nag[j];
      j--;
    }
  }
  fit->n = j + 1;
  fit->nag = nag;
  fit->val = val;

  for ( i = 0, k = 0; i < fit->n; i++ ) {
    for ( j = 0; j < fit->nag[i]; j++, k++ ) {
      vect[k] = fit->val[i];
    }
  }

  free( fit->nag );
  free( fit->val );
  free( fit );
}
