      SUBROUTINE PAV(K, X, IORDER, W, FINALX, NW, FX, PW, W1, WT)
C
C       ALGORITHM AS 206.1 APPL. STATST. (1984) VOL.33, NO.3 
C 
C       SUBROUTINE TO APPLY POOL ADJACENT VIOLATORS THEOREM 
C 
      INTEGER K, IORDER
      INTEGER NW(K) 
      DOUBLE PRECISION X(K), W(K), FINALX(K), FX(K), PW(K), W1(K), WT(K)
      INTEGER NWC, I, IBEL, I1, J, J1, L, JL, JU, ICOUNT
      DOUBLE PRECISION EPS 
C 
      EPS = 0.000001 
C 
C SET UP WORKSPACE 
C 
      NWC = K 
      DO 10 I = 1, K 
        NW(I) = 1
        FX(I) = X(I) 
        IF (IORDER .EQ. 0) FX(I) = -FX(I) 
        WT(I) = W(I) 
        PW(I) = WT(I) * FX(I) 
        W1(I) = W(I) 
   10 CONTINUE 
      IBEL = K - 1
   20 I = 0 
   30   I = I + 1 
   35   IF (I .GT. IBEL) GOTO 50 
        I1 = I + 1 
C 
C DETERMINE IF POOLING IS REQUIRED 
C 
        IF (FX(I) - FX(I1) .LE. EPS) GOTO 30 
C 
C POOL THE ADJACENT VALUES 
C 
        PW(I) = PW(I) + PW(I1) 
        W1(I) = W1(I) + W1(I1) 
        FX(I) = PW(I) / W1(I) 
        NW(I) = NW(I) + NW(I1) 
        NWC = NWC - 1 
        IF (I1 .GT. IBEL) GOTO 45 
        DO 40 J = I1, IBEL 
          J1 = J + 1 
          PW(J) = PW(J1) 
          W1(J) = W1(J1) 
          FX(J) = FX(J1) 
          NW(J) = NW(J1)
   40   CONTINUE 
   45   IBEL = IBEL - 1 
        GOTO 35 
   50 ICOUNT = 0 
      IF (IBEL .LE. 0) GOTO 70 
C 
C DETERMINE IF ALL VALUES ARE ORDERED 
C 
        DO 60 L = 1, IBEL 
   60     IF (FX(L) - FX(L + 1) .LE. EPS) ICOUNT = ICOUNT + 1 
      IF (ICOUNT .NE. IBEL) GOTO 20 
C 
C RECOVER FINAL ORDERED VALUES 
C
   70 J = 1 
      JL = 1 
      JU = NW(1) 
   80 DO 90 L = JL, JU 
   90     FINALX(L) = FX(J) 
        J = J + 1 
        IF (J .GT. NWC) GOTO 100 
        JL = JU + 1 
        JU = JU + NW(J)
      GOTO 80 
  100 IF (IORDER .EQ. 1) RETURN 
      DO 110 I = 1, K 
  110   FINALX(I) = -FINALX(I) 
      RETURN 
      END 