## Hierarchical Clustering with Contiguity Constraint in R --
## Manuscript replication script
library("adespatial")

## Synthetic example: Load the synthetic example data
load(file = "ccl_ex.rda")
source("v103i07-auxiliary.R")

## Figure 2
# dev.new(height = 3.5)
par(mar = c(5, 5, 2, 2))
plotData(ccl_ex[[1L]], ccl_ex[[1L]]$obs, 6L, col = rep("black", 6L))
# dev.off()
##
printLink(ccl_ex[[1L]])
altPrintDist(ccl_ex[[1L]]$dmat)
## mergeDistWard(ccl_ex[[1L]]$dmat,ccl_ex[[1L]]$n, 4L, 5L)
## mergeDistSingle(ccl_ex[[1L]]$dmat,ccl_ex[[1L]]$n, 4L, 5L)
## mergeDistComplete(ccl_ex[[1L]]$dmat,ccl_ex[[1L]]$n, 4L, 5L)
mergeCcluster(ccl_ex[[1L]], 4L, 5L, mergeDistWard)
## mergeCcluster(ccl_ex[[1L]], 4L, 5L,mergeDistSingle)
## mergeCcluster(ccl_ex[[1L]], 4L, 5L,mergeDistComplete)
printLWEqWard(ccl_ex[[1L]], 4L, 5L)
ccl_ex[[2L]] <- mergeCcluster(ccl_ex[[1L]], 4L, 5L, mergeDistWard)
altPrintDist(ccl_ex[[2L]]$dmat)
printLink(ccl_ex[[2L]])
##
printLWEqWard(ccl_ex[[2L]], 4L, 6L)
ccl_ex[[3L]] <- mergeCcluster(ccl_ex[[2L]], 4L, 6L, mergeDistWard)
altPrintDist(ccl_ex[[3L]]$dmat)
printLink(ccl_ex[[3L]])
##
printLWEqWard(ccl_ex[[3L]], 1L, 2L)
ccl_ex[[4L]] <- mergeCcluster(ccl_ex[[3L]], 1L, 2L, mergeDistWard)
altPrintDist(ccl_ex[[4L]]$dmat)
printLink(ccl_ex[[4L]])
##
printLWEqWard(ccl_ex[[4L]], 3L, 4L)
ccl_ex[[5L]] <- mergeCcluster(ccl_ex[[4L]], 3L, 4L, mergeDistWard)
altPrintDist(ccl_ex[[5L]]$dmat)
printLink(ccl_ex[[5L]])
## This last step is not necessary for the example:
printLWEqWard(ccl_ex[[5L]], 1L, 3L)
ccl_ex[[6L]] <- mergeCcluster(ccl_ex[[5L]], 1L, 3L, mergeDistWard)
altPrintDist(ccl_ex[[6L]]$dmat)
printLink(ccl_ex[[6L]])

## Figure 4
# dev.new(height = 3.5)
par(mar = c(2, 5, 2, 2))
stats:::plot.hclust(ccl_ex[[1L]]$ccl, main = "", xlab = "", ann = FALSE)
# dev.copy2pdf(file = "Figures/plotDendro.pdf")
# dev.off()

## Figure 3
# dev.new(width = 7.25, height = 9)
par(mfrow = c(3L, 2L))
par(mar = c(3, 5, 2, 0))
plotData(ccl_ex[[1L]], ccl_ex[[1L]]$obs, 6L, val = FALSE, xlab = "", ylab = "", col = c("black",
  "black", "black", "black", "black", "black"), lnklab = FALSE)
text(x = -2.75, y = 2, labels = "A) Before clustering", cex = 1.5, adj = 0)
par(mar = c(3, 3, 2, 2))
plotData(ccl_ex[[1L]], ccl_ex[[1L]]$obs, 5L, val = FALSE, xlab = "", ylab = "", col = c("black",
  "black", "black", "red", "black"), lnklab = FALSE)
text(x = -2.75, y = 2, labels = "B) First step", cex = 1.5, adj = 0)
par(mar = c(4, 5, 1, 0))
plotData(ccl_ex[[1L]], ccl_ex[[1L]]$obs, 4L, val = FALSE, xlab = "", ylab = "", col = c("black",
  "black", "black", "red"), lnklab = FALSE)
text(x = -2.75, y = 2, labels = "C) Second step", cex = 1.5, adj = 0)
par(mar = c(4, 3, 1, 2))
plotData(ccl_ex[[1L]], ccl_ex[[1L]]$obs, 3L, val = FALSE, xlab = "", ylab = "", col = c("blue",
  "black", "red"), lnklab = FALSE)
text(x = -2.75, y = 2, labels = "D) Third step", cex = 1.5, adj = 0)
par(mar = c(5, 5, 0, 0))
plotData(ccl_ex[[1L]], ccl_ex[[1L]]$obs, 2L, val = FALSE, xlab = "", ylab = "", col = c("blue",
  "red"), lnklab = FALSE)
text(x = -2.75, y = 2, labels = "E) Fourth step", cex = 1.5, adj = 0)
par(mar = c(5, 3, 0, 2))
plotData(ccl_ex[[1L]], ccl_ex[[1L]]$obs, 1L, val = FALSE, xlab = "", ylab = "", col = c("red"),
  lnklab = FALSE)
text(x = -2.75, y = 2, labels = "F) Last step", cex = 1.5, adj = 0)
mtext("X (km)", 1L, -2, TRUE, 0.525)
mtext("Y (km)", 2L, -2, TRUE, 0.525)
# dev.copy2pdf(file = "Figures/plotExSteps.pdf")
# dev.off()

## Figure 5
# dev.new(height = 6, width = 7.25)
par(mfrow = c(2L, 2L))
par(mar = c(3, 5, 2, 0))
plot(NA, xlim = c(-2, 2), ylim = c(-2, 2.25), xlab = "", ylab = "", asp = 1)
lapply(ccl_ex[[1L]]$obs, function(x) polygon(x = x[, 1L], y = x[, 2L], col = "grey90"))
plot(ccl_ex[[1L]]$ccl, 2L, link = TRUE, plot = FALSE, col = c("red", "violet"), pch = 21L,
  hybrids = "single", lty.hyb = 3L, cex = 2, lwd.hyb = 1/3, lwd = 2)
text(x = -2.75, y = 2, labels = "A) Two clusters", cex = 1.25, adj = 0)
par(mar = c(3, 3, 2, 2))
plot(NA, xlim = c(-2, 2), ylim = c(-2, 2.25), xlab = "", ylab = "", asp = 1)
lapply(ccl_ex[[1L]]$obs, function(x) polygon(x = x[, 1L], y = x[, 2L], col = "grey90"))
plot(ccl_ex[[1L]]$ccl, 3L, link = TRUE, plot = FALSE, col = c("red", "green", "violet"),
  pch = 21L, hybrids = "single", lty.hyb = 3L, cex = 2, lwd.hyb = 1/3, lwd = 2)
text(x = -2.75, y = 2, labels = "B) Three clusters", cex = 1.25, adj = 0)
par(mar = c(5, 5, 0, 0))
plot(NA, xlim = c(-2, 2), ylim = c(-2, 2.25), xlab = "", ylab = "", asp = 1)
lapply(ccl_ex[[1L]]$obs, function(x) polygon(x = x[, 1L], y = x[, 2L], col = "grey90"))
plot(ccl_ex[[1L]]$ccl, 4L, link = TRUE, plot = FALSE, col = c("red", "yellow", "green",
  "violet"), pch = 21L, hybrids = "single", lty.hyb = 3L, cex = 2, lwd.hyb = 1/3,
  lwd = 2)
text(x = -2.75, y = 2, labels = "C) Four clusters", cex = 1.25, adj = 0)
par(mar = c(5, 3, 0, 2))
plot(NA, xlim = c(-2, 2), ylim = c(-2, 2.25), xlab = "", ylab = "", asp = 1)
lapply(ccl_ex[[1L]]$obs, function(x) polygon(x = x[, 1L], y = x[, 2L], col = "grey90"))
plot(ccl_ex[[1L]]$ccl, 5L, link = TRUE, plot = FALSE, col = c("red", "yellow", "green",
  "blue", "violet"), pch = 21L, hybrids = "single", lty.hyb = 3L, cex = 2, lwd.hyb = 1/3,
  lwd = 2)
text(x = -2.75, y = 2, labels = "D) Five clusters", cex = 1.25, adj = 0)
mtext("X (km)", 1L, -2, TRUE, 0.525)
mtext("Y (km)", 2L, -2, TRUE, 0.525)
# dev.copy2pdf(file = "Figures/plotPartitions.pdf")
# dev.off()

## Application examples Oribatid
library("adespatial")
library("magrittr")
library("spdep")
library("vegan")
##
data("mite", package = "vegan")
data("mite.xy", package = "vegan")

## Calculating Delauney triangulation:
mite.edge <- mite.xy %>%
  tri2nb %>%
  nb2listw(style = "B") %>%
  listw2sn
##
names(mite.edge)[3L] <- "distance"

## Calculating the length of the links (here, the Euclidean distance between
## the locations at the end of the links):
mite.edge$distance <- mite.xy %>%
  dist %>%
  as.matrix %>%
  .[mite.edge[, 1L:2L] %>%
    as.matrix]

## Keeping only the links shorter than 1.5 meters:
mite.edge %<>%
  .[.$distance <= 1.5, ]

## Figure 6
# dev.new(width = 10, height = 2.6)
par(mar = rep(0, 4))
plot(NA, xlim = c(10, 0), ylim = c(-0.1, 2.5), asp = 1)
arrows(x0 = 9.85, x1 = 8.85, y0 = 0.15, y1 = 0.15, code = 3, length = 0.05, angle = 90,
  lwd = 2)
text(x = 9.35, y = 0.025, labels = "1m")
apply(mite.edge, 1L, function(x, xy) {
  segments(x0 = xy[x[1], 1], x1 = xy[x[2], 1], y0 = xy[x[1], 2], y1 = xy[x[2],
    2])
}, xy = mite.xy[, c(2, 1)])
points(mite.xy[, c(2, 1)], cex = 1.25, pch = 21, bg = "black")
text(label = "Water", x = 9.8, y = 1.75, srt = 90)
text(label = "Forest", x = 0.2, y = 1.75, srt = 90)
# dev.copy2pdf(file = "Figures/miteMap.pdf")
# dev.off()
##
mite.hel <- mite %>%
  dist.ldc("hellinger")
##
mite.chclust <- constr.hclust(d = mite.hel, links = mite.edge, coords = mite.xy[,
  c(2, 1)])

## Figure 7
## stats:::plot.hclust(mite.chclust)
# dev.new(width = 7.25, height = 7.54)
par(mfrow = c(4, 1), mar = c(0.5, 0, 0.5, 0))
cols <- c("turquoise", "orange", "blue", "violet", "green", "red", "purple")
parts <- c(2, 3, 5, 7)
for (i in 1L:length(parts)) {
  ## i=1L
  plot(NA, xlim = c(10, 0), ylim = c(-0.1, 2.5), xaxs = "i", yaxs = "i", asp = 1,
    axes = FALSE)
  arrows(x0 = 9.85, x1 = 8.85, y0 = 0.1, y1 = 0.1, code = 3, length = 0.05, angle = 90,
    lwd = 2)
  text(x = 9.35, y = 0, labels = "1m", cex = 1.5)
  plot(mite.chclust, parts[i], links = TRUE, plot = FALSE, col = cols[round(seq(1,
    length(cols), length.out = parts[i]))], lwd = 4, cex = 2.5, pch = 21, hybrids = "single",
    lwd.hyb = 0.25, lty.hyb = 3, xpd = TRUE)
  text(x = 9.75, y = 2.25, labels = LETTERS[i], cex = 2.5)
}
# dev.copy2pdf(file = "Figures/miteClust.pdf")
# dev.off()

## Without the constraint:
mite.all <- cbind(rep(1:nrow(mite.xy), nrow(mite.xy)), rep(1:nrow(mite.xy), each = nrow(mite.xy))) %>%
  .[.[, 1L] < .[, 2L], ]
##
mite.hclust <- constr.hclust(d = mite.hel, links = mite.all, coords = mite.xy[, c(2,
  1)])

## Figure 8
## stats:::plot.hclust(mite.chclust)
# dev.new(width = 7.25, height = 7.54)
par(mfrow = c(4, 1), mar = c(0.5, 0, 0.5, 0))
cols <- c("turquoise", "orange", "blue", "violet", "green", "red", "purple")
parts <- c(2, 3, 5, 7)
for (i in 1L:length(parts)) {
  ## i=1L
  plot(NA, xlim = c(10, 0), ylim = c(-0.1, 2.5), xaxs = "i", yaxs = "i", asp = 1,
    axes = FALSE)
  arrows(x0 = 9.85, x1 = 8.85, y0 = 0.1, y1 = 0.1, code = 3, length = 0.05, angle = 90,
    lwd = 2)
  text(x = 9.35, y = 0, labels = "1m", cex = 1.5)
  plot(mite.hclust, parts[i], links = TRUE, plot = FALSE, col = cols[round(seq(1,
    length(cols), length.out = parts[i]))], lwd = 1.5, cex = 2.5, pch = 21, hybrids = "single",
    lwd.hyb = 0.25, lty.hyb = 3, xpd = TRUE)
  text(x = 9.75, y = 2.25, labels = LETTERS[i], cex = 2.5)
}
# dev.copy2pdf(file = "Figures/miteClust2.pdf")
# dev.off()

## Tiahura
data("Tiahura", package = "adespatial")
##
tiah.jac <- Tiahura$fish %>%
  dist.ldc(method = "jaccard")
tiah.chclust <- constr.hclust(d = tiah.jac, coords = Tiahura$habitat[, "distance"],
  chron = TRUE)

## Figure 9
# dev.new(width = 7.25, height = 7.25)
par(mfrow = c(3, 1))
par(mar = c(3, 6.5, 2, 2))
dst <- Tiahura$habitat[, "distance"]
plot(NA, xlim = dst %>%
  range, ylim = c(0.5, 5.5), yaxt = "n", ylab = "Partitions\n\n", xlab = "")
parts <- c(2, 3, 5, 7, 12)
cols <- c("turquoise", "orange", "chartreuse", "aquamarine", "blue", "violet", "pink",
  "cyan", "green", "red", "cornsilk", "purple")
for (i in 1L:length(parts)) {
  tiah.chclust$coords[, "y"] <- i
  plot(tiah.chclust, parts[i], link = TRUE, lwd = 3, hybrids = "none", lwd.pt = 0.5,
    cex = 3, pch = 21, plot = FALSE, col = cols[round(seq(1, length(cols), length.out = parts[i]))])
}
axis(2, at = 1:length(parts), labels = paste(parts, "groups"), las = 1)
par(mar = c(4, 6.5, 1, 2))
plot(x = dst, y = Tiahura$habitat[, "depth"], ylim = Tiahura$habitat[, "depth"] %>%
  range %>%
  max %>%
  c(-300), las = 1, ylab = "Depth\n(cm)\n", xlab = "", type = "l", lwd = 2)
##
for (i in 1:nrow(Tiahura$reef)) {
  abline(v = Tiahura$reef[i, 2], lty = 3)
  abline(v = Tiahura$reef[i, 3], lty = 3)
  if ((Tiahura$reef[i, 3] - Tiahura$reef[i, 2]) < 100) {
    text(x = (Tiahura$reef[i, 2] + Tiahura$reef[i, 3])/2, y = 2350, labels = toupper(Tiahura$reef[i,
      1]), srt = 90, adj = 0)
  } else {
    text(x = (Tiahura$reef[i, 2] + Tiahura$reef[i, 3])/2, y = -150, labels = toupper(Tiahura$reef[i,
      1]))
  }
}
par(mar = c(5, 6.5, 0, 2))
plot(NA, xlim = dst %>%
  range, ylim = c(0, 1), las = 1, ylab = "Bottom composition\n(proportions)\n",
  xlab = "Distance (m)")
bot <- cbind(0, Tiahura$habitat[, 3:10])
for (i in 2:9) bot[, i] <- bot[, i] + bot[, i - 1]
cols <- c("", "grey75", "brown", "grey25", "green", "purple", "lightgreen", "yellow",
  "white")
for (i in 2:9) polygon(x = c(dst, rev(dst)), y = c(bot[, i], rev(bot[, i - 1]))/50,
  col = cols[i])
text(x = c(44, 365, 707, 538, 957, 111, 965), y = c(0.05, 0.47, 0.37, 0.58, 0.42,
  0.8, 0.88), labels = colnames(bot)[2:8], xpd = TRUE)
# dev.copy2pdf(file = "Figures/tiahuraPlot.pdf")
# dev.off()

## Without the constraint:
tiah.all <- cbind(rep(1:nrow(Tiahura$fish), nrow(Tiahura$fish)), rep(1:nrow(Tiahura$fish),
  each = nrow(Tiahura$fish))) %>%
  .[.[, 1L] < .[, 2L], ]
##
tiah.hclust <- constr.hclust(d = tiah.jac, links = tiah.all, coords = Tiahura$habitat[,
  "distance"])

## Figure 10
# dev.new(width = 7.25, height = 2.75)
par(mar = c(3, 6.5, 2, 2))
dst <- Tiahura$habitat[, "distance"]
plot(NA, xlim = dst %>%
  range, ylim = c(0.5, 5.5), yaxt = "n", ylab = "Partitions\n\n", xlab = "")
parts <- c(2, 3, 5, 7, 12)
cols <- c("turquoise", "orange", "chartreuse", "aquamarine", "blue", "violet", "pink",
  "cyan", "green", "red", "cornsilk", "purple")
for (i in 1L:length(parts)) {
  tiah.hclust$coords[, "y"] <- i
  plot(tiah.hclust, parts[i], link = TRUE, lwd = 3, hybrids = "none", lwd.pt = 0.5,
    cex = 2, pch = 21, plot = FALSE, col = cols[round(seq(1, length(cols), length.out = parts[i]))])
}
axis(2, at = 1:length(parts), labels = paste(parts, "groups"), las = 1)
# dev.copy2pdf(file = "Figures/tiahuraPlot2.pdf")
# dev.off()

## Benchmarks: Figure 11
# dev.new(height = 5.5, width = 7.25)
load(file = "Benchmarks.rda")
ok <- res %>%
  apply(1L, function(x) !x %>%
    is.na %>%
    any)
par(mar = c(3, 6, 2, 2), mfrow = c(2L, 1L))
plot(y = res[ok, "Time (sec)"], x = res[ok, "N.objects"], ylab = "Time (seconds)\n",
  xlab = "", las = 1L, log = "xy", type = "b", pch = 21L, bg = "black")
par(mar = c(5, 6, 0, 2))
plot(y = res[ok, "Storage (MiB)"], x = res[ok, "N.objects"], ylab = "Total storage (MB)\n",
  xlab = "Number of observations", las = 1L, log = "xy", type = "b", pch = 21L,
  bg = "black")
# dev.copy2pdf(file = "Figures/benchmarks.pdf")
# dev.off()
##
