##
plotData <- function(x, obs, wh, col, val = TRUE, lnklab = TRUE, ...) {
  plot(x$ccl, wh, xlim = c(-2, 2), ylim = c(-2, 2.25), links = TRUE, col = col,
    lwd = 3, ...)
  lapply(obs, function(x) polygon(x = x[, 1L], y = x[, 2L], col = "grey90"))
  if (lnklab)
    sapply(1L:nrow(x$lnk), function(i, x, y, labels) {
      px <- 0.5 * (y[x[i, "From"], "x"] + y[x[i, "To"], "x"])
      py <- 0.5 * (y[x[i, "From"], "y"] + y[x[i, "To"], "y"])
      points(x = px, y = py, pch = 22L, cex = 3.5, bg = "white")
      text(x = px, y = py, labels = labels[i], font = 2L)
    }, x = x$lnk, y = cbind(x = x$dat$X, y = x$dat$Y), labels = rownames(x$lnk))
  points(x = x$dat$X, y = x$dat$Y, cex = 3.5, pch = 21L, bg = "white")
  text(x = x$dat$X, y = x$dat$Y, labels = x$dat$Id, font = 2L)
  if (val)
    text(x = x$dat$X, y = x$dat$Y + 0.25, labels = x$dat$Value, font = 2L, col = "red")
}

##
printLink <- function(x, ...) {
  d <- as.matrix(x$dmat)
  diag(d) <- NA
  tmp <- cbind(x$lnk, Dissimilarity = round(d[as.matrix(x$lnk)], 2L))
  cat("\\hline\n")
  cat(" & ", paste(colnames(tmp), collapse = " & "), "\\\\ \\hline\n")
  apply(cbind(rownames(tmp), tmp), 1L, function(x) {
    x[is.na(x)] <- "---"
    cat(paste(x, collapse = " & "), "\\\\\n")
  })
  cat("\\hline\n")
  invisible(x)
}

##
altPrintDist <- function(x, diag = NULL, upper = NULL, digits = getOption("digits"),
  justify = "none") {
  x <- round(x, 2L)
  if (is.null(diag))
    diag <- if (is.null(a <- attr(x, "Diag")))
      FALSE else a
  if (is.null(upper))
    upper <- if (is.null(a <- attr(x, "Upper")))
      FALSE else a
  m <- as.matrix(x)
  cf <- format(m, digits = digits, justify = justify)
  if (!upper)
    cf[row(cf) < col(cf)] <- ""
  if (!diag)
    cf[row(cf) == col(cf)] <- ""
  cf <- if (diag || upper)
    cf else cf[-1, -attr(x, "Size"), drop = FALSE]
  cat("\\hline\n")
  cat(" & ", paste(sprintf("$\\mathbf{%s}$", colnames(cf)), collapse = " & "),
    "\\\\ \\hline\n")
  tmp <- cbind(sprintf("$\\mathbf{%s}$", rownames(cf)), cf)
  apply(tmp, 1L, function(x) {
    x[is.na(x) | (trimws(x) == "NA")] <- "---"
    cat(paste(x, collapse = " & "), "\\\\\n")
  })
  cat("\\hline\n")
  invisible(x)
}

##
mergeDistWard <- function(d, n, i, j) {
  d <- as.matrix(d)
  for (k in (1L:nrow(d))[-c(i, j)]) {
    nh <- n[i] + n[j]
    ai <- (n[i] + n[k])/(nh + n[k])
    aj <- (n[j] + n[k])/(nh + n[k])
    beta <- -n[k]/(nh + n[k])
    ## h is stored in i
    d[i, k] <- ai * d[i, k] + aj * d[j, k] + beta * d[i, j] + 0 * abs(d[i, k] -
      d[j, k])
    d[k, i] <- d[i, k]
  }
  ## j is no more
  d[j, ] <- d[, j] <- NA
  as.dist(d)
}

##
mergeDistSingle <- function(d, n, i, j) {
  d <- as.matrix(d)
  for (k in (1L:nrow(d))[-c(i, j)]) {
    d[i, k] <- 0.5 * d[k, i] + 0.5 * d[k, j] - 0 * d[i, j] - 0.5 * abs(d[k, i] -
      d[k, j])
    d[k, i] <- d[i, k]
  }
  d[j, ] <- d[, j] <- NA
  as.dist(d)
}

##
mergeDistComplete <- function(d, n, i, j) {
  d <- as.matrix(d)
  for (k in (1L:nrow(d))[-c(i, j)]) {
    d[i, k] <- 0.5 * d[k, i] + 0.5 * d[k, j] - 0 * d[i, j] + 0.5 * abs(d[k, i] -
      d[k, j])
    d[k, i] <- d[i, k]
  }
  d[j, ] <- d[, j] <- NA
  as.dist(d)
}
##
mergeCcluster <- function(x, i, j, update) {
  x <- x[c("n", "lnk", "dmat")]
  x$dmat <- update(x$dmat, x$n, i, j)
  x$lnk[x$lnk == j] <- i
  x$n[i] <- x$n[i] + x$n[j]
  x$n[j] <- 0
  x
}

##
printLWEqWard <- function(x, i, j) {
  d <- as.matrix(x$dmat)
  n <- x$n
  iter <- (1L:nrow(d))[-c(i, j)]
  eq <- NULL
  for (k in iter) {
    nh <- n[i] + n[j]
    ai <- (n[i] + n[k])/(nh + n[k])
    aj <- (n[j] + n[k])/(nh + n[k])
    beta <- -n[k]/(nh + n[k])
    d[i, k] <- ai * d[i, k] + aj * d[j, k] + beta * d[i, j] + 0 * abs(d[i, k] -
      d[j, k])
    d[k, i] <- d[i, k]
    if (!is.na(d[i, k])) {
      eq[length(eq) + 1L] <- paste(sprintf("d_{%d,h} &= ", k), sprintf("\\frac{%d+%d}{%d+%d} d_{%d,%d}",
        n[i], n[k], nh, n[k], k, i), sprintf(" + \\frac{%d+%d}{%d+%d} d_{%d,%d}",
        n[j], n[k], nh, n[k], k, j), sprintf(" - \\frac{%d}{%d+%d} d_{%d,%d}",
        n[k], nh, n[k], i, j), sprintf(" + 0 |d_{%d,%d} - d_{%d,%d}|", k,
        i, k, j), sprintf(" = %.2f%%s", d[i, k]), sep = "")
    }
  }
  if (length(eq)) {
    cat("\\begin{align*}\n")
    for (l in 1L:length(eq)) {
      el <- "\\mathrm{,}"
      if (l == length(eq))
        el <- "\\mathrm{.}"
      if ((length(eq) == 2L) && (l == 1L))
        el <- "\\,\\mathrm{and}"
      if ((length(eq) > 2L) && (l == (length(eq) - 1L)))
        el <- "\\mathrm{, and}"
      cat(sprintf(eq[l], el))
      if (l != length(eq))
        cat("\\\\")
      cat("\n")
    }
    cat("\\end{align*}\n")
  }
  invisible(NULL)
}
