
library("MultipleBubbles")
library("psymonitor")
library("exuber")
options(exuber.show_progress = FALSE)


# 4. Computational Approach to Estimation and Performance -----------------

# Modify MultipleBubbles::sadf_gsadf() to allow for user-specified minimum window
mb_mod <- function(y, adflag, mflag, IC, minw = NULL, parallel = FALSE){
  t <- length(y)
  #  <<<<<<< Modified here
  # r0 <- 0.01 + 1.8/sqrt(t)
  # swindow0 <- floor(r0 * t)
  swindow0 <- minw
  # >>>>>> From here on it is the same
  dim <- t - swindow0 + 1
  badfs <- matrix(0, nrow = (t - swindow0 + 1), ncol = 1)
  for (i in swindow0:t) {
    badfs[(i - swindow0 + 1), 1] <- as.numeric(MultipleBubbles::ADF_IC(y[(1:i)], 
                                                                       adflag, mflag, IC))
  }
  sadf <- max(badfs)
  r2 <- swindow0:t
  r2 <- t(r2)
  rw <- r2 - swindow0 + 1
  bsadfs <- matrix(0, nrow = 1, ncol = dim)
  for (v in 1:length(r2)) {
    swindow <- swindow0:r2[v]
    r1 <- r2[v] - swindow + 1
    rwadft <- matrix(0, nrow = length(swindow), ncol = 1)
    for (i in 1:length(swindow)) {
      rwadft[i] <- as.numeric(MultipleBubbles::ADF_IC(y[(r1[i]:r2[v])], 
                                                      adflag, mflag, IC))
    }
    bsadfs[1, v] <- max(rwadft)
  }
  if (parallel == T) {
    foreach(v = 1:length(r2)) %dopar% {
      swindow <- swindow0:r2[v]
      r1 <- r2[v] - swindow + 1
      rwadft <- matrix(0, nrow = length(swindow), ncol = 1)
      foreach(i = 1:length(swindow)) %dopar% {
        rwadft[i] <- as.numeric(MultipleBubbles::ADF_IC(y[(r1[i]:r2[v])], 
                                                        adflag, mflag, IC))
      }
      bsadfs[1, v] <- max(rwadft)
    }
  }
  gsadf <- max(bsadfs[1, ])
  bsadfs <- matrix(bsadfs)
  result <- list(badfs = badfs, bsadfs = bsadfs, sadf = sadf, 
                 gsadf = gsadf)
  return(result)
}


minw <- 30
sample_size <- seq(100, 1000, 100)

# Begin Benchmark ~ (output saved in performance-comparison.RData)
bench <- list()
for (i in seq_along(sample_size)) {
  set.seed(123)
  rw <- cumsum(rnorm(sample_size[i]))
  bench[[i]] <- microbenchmark::microbenchmark(
    mb_mod(rw, minw = minw, adflag = 1, mflag = 1, IC = 1),
    psymonitor::PSY(rw, swindow0 = minw, adflag = 1),
    exuber::radf(rw, minw = minw, lag = 1),
    unit = "ms",
    times = 100
  )
}

elapsed_r <- bench %>% 
  map( ~ summary(.x)$median %>% set_names(c("mb","psymonitor", "exuber"))) %>% 
  reduce(bind_rows) %>% 
  arrange(exuber) 

write.csv(elapsed_r, "elapsed-r.txt", row.names = FALSE)
