% -----------------------------------------------------------------------
%  "Testing for Multiple Bubbles" by Phillips, Shi and Yu (2015)
    
%    In this program, we calculate the ADF statistic with a lag order
%    selected by AIC/BIC.

% The ADF_IC procedure arguments:
% y: data
%  IC: 0 for fixed lag order 1 for AIC and 2 for BIC
% adflag: lag order when IC=0; maximum number of lags when IC>0

% written by Shuping Shi @ Macquarie University
%-------------------------------------------------------------------------


function ADFlag = ADF(y, IC, adflag)

T0 = length(y);
T1 = size(y, 1) - 1; const = ones(T1, 1); 

y1  = y(1:T1);
dy  = y(2:T0)- y(1:T1);
x1 = [y1 const]; 

T = T1 - adflag;
dof = T - 2;

if IC > 0
            ICC = zeros(adflag + 1, 1);
            ADF = zeros(adflag + 1, 1);
            
            for k = 0:1:adflag
                  % Model specification
                   xx = x1(adflag + 1:T1, :); % @-from k+1 to the end (including y1 and x)-@
                   dy01 = dy(adflag + 1:T1);  % @-from k+1 to the end (including dy0)-@

                   if k > 0
                           x2 = [xx zeros(T, k)];
                           for j = 1:1:k
                              x2(:, size(xx, 2) + j) = dy(adflag + 1 - j:T1 - j); % @-including k lag variables of dy in x2-@
                           end
                   else
                          x2 = xx;
                   end
                   
                   % OLS regression
                   beta = (x2'*x2)\(x2'*dy01); % @-model A-@
                   eps  = dy01 - x2*beta;

                   % Information Criteria
                  npdf = sum(-1/2*log(2*pi) - 1/2*(eps.^2));
                 if IC == 1  % @ AIC @
                        ICC(k + 1) = -2*npdf/T + 2*size(beta, 1)/T;
                 elseif IC == 2 % @ BIC @
                        ICC(k + 1) = -2*npdf/T + size(beta, 1)*log(T)/T;
                 end

                se = eps'*eps/dof;
                sig = sqrt(diag(se*inv(x2'*x2)));

                ADF(k + 1) = beta(1)/sig(1);
            end
            
            [~, lag0] = min(ICC);
            ADFlag = ADF(lag0);
            % lag = lag0 - 1;
            
elseif IC == 0
  
              %% Model specification
               xx = x1(adflag + 1:T1,:); % @-from k+1 to the end (including y1 and x)-@
               dy01 = dy(adflag + 1:T1); % @-from k+1 to the end (including dy0)-@

               if adflag > 0
                       x2 = [xx zeros(T, adflag)];
                       for j = 1:1:adflag
                          x2(:, size(xx, 2) + j) = dy(adflag + 1 - j:T1 - j); % @-including k lag variables of dy in x2-@
                       end
               else
                      x2 = xx;
               end

               %% OLS regression
               beta = (x2'*x2)\(x2'*dy01); % @-model A-@
               eps  = dy01 - x2*beta;

               se = eps'*eps/dof;
               sig= sqrt(diag(se*inv(x2'*x2)));

               ADFlag = beta(1)/sig(1);
end



