%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This procedure is to implement the real time bubble detection procedure of 
% Phillips, Shi and Yu (2015a,b)

%%%%%%%%%% INPUT %%%%%%%%%%%%%
%y:                        data
% swindow0:    minimum window size
% IC:                    0 fixed lag 1 for AIC and 2 for BIC

%%%%%%%%%% OUTPUT %%%%%%%%%%%%%     
% bsadf: the PSY test statistic

% written by Shuping Shi @ Macquarie University
%-------------------------------------------------------------------------

function bsadf = PSY(y, swindow0, IC, adflag)

T = length(y);
bsadfs = NaN(T, 1); 
for r2 = swindow0:1:T
    rwadft = zeros(r2 - swindow0 + 1, 1);
    for r1 = 1:1:r2 - swindow0 + 1
               rwadft(r1) = ADF(y(r1:r2, 1), IC, adflag); % two tail 5% significant level
    end
    bsadfs(r2) = max(rwadft);
end

 bsadf = bsadfs(swindow0:T);
 
