package jss;

import blang.core.ConstantSupplier;
import blang.core.DeboxedName;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.Param;
import blang.core.RealVar;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;

@SuppressWarnings("all")
public class Doomsday implements Model {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public RealVar z;
    
    private boolean z_initialized = false;
    
    public Doomsday.Builder setZ(final RealVar z) {
      z_initialized = true;
      this.z = z;
      return this;
    }
    
    @Arg
    public RealVar y;
    
    private boolean y_initialized = false;
    
    public Doomsday.Builder setY(final RealVar y) {
      y_initialized = true;
      this.y = y;
      return this;
    }
    
    @Arg
    public RealVar rate;
    
    private boolean rate_initialized = false;
    
    public Doomsday.Builder setRate(final RealVar rate) {
      rate_initialized = true;
      this.rate = rate;
      return this;
    }
    
    public Doomsday build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      if (!fromCommandLine && !z_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing z");
      final RealVar __z = z;
      if (!fromCommandLine && !y_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing y");
      final RealVar __y = y;
      if (!fromCommandLine && !rate_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing rate");
      final RealVar __rate = rate;
      // Build the instance after boxing params
      return new Doomsday(
        __z, 
        __y, 
        new ConstantSupplier(__rate)
      );
    }
  }
  
  @DesignatedConstructor
  public static Doomsday.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  private final RealVar z;
  
  public RealVar getZ() {
    return z;
  }
  
  private final RealVar y;
  
  public RealVar getY() {
    return y;
  }
  
  @Param
  private final Supplier<RealVar> $generated__rate;
  
  public RealVar getRate() {
    return $generated__rate.get();
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * z
   */
  private static RealVar $generated__0(final RealVar z, final RealVar y, final RealVar rate) {
    return z;
  }
  
  /**
   * Auxiliary method generated to translate:
   * rate
   */
  private static RealVar $generated__1(final RealVar rate) {
    return rate;
  }
  
  public static class $generated__1_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__1($generated__rate.get());
    }
    
    public String toString() {
      return "rate";
    }
    
    private final Supplier<RealVar> $generated__rate;
    
    public $generated__1_class(final Supplier<RealVar> $generated__rate) {
      this.$generated__rate = $generated__rate;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * y
   */
  private static RealVar $generated__2(final RealVar z, final RealVar y, final RealVar rate) {
    return y;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 0.0
   */
  private static RealVar $generated__3(final RealVar z) {
    return new blang.core.RealConstant(0.0);
  }
  
  public static class $generated__3_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__3(z);
    }
    
    public String toString() {
      return "0.0";
    }
    
    private final RealVar z;
    
    public $generated__3_class(final RealVar z) {
      this.z = z;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * z
   */
  private static RealVar $generated__4(final RealVar z) {
    return z;
  }
  
  public static class $generated__4_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__4(z);
    }
    
    public String toString() {
      return "z";
    }
    
    private final RealVar z;
    
    public $generated__4_class(final RealVar z) {
      this.z = z;
    }
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public Doomsday(@DeboxedName("z") final RealVar z, @DeboxedName("y") final RealVar y, @Param @DeboxedName("rate") final Supplier<RealVar> $generated__rate) {
    this.z = z;
    this.y = y;
    this.$generated__rate = $generated__rate;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    { // Code generated by: z | rate ~ Exponential(rate)
      // Construction and addition of the factor/model:
      components.add(
        new blang.distributions.Exponential(
          $generated__0(z, y, $generated__rate.get()), 
          new $generated__1_class($generated__rate)
        )
        );
    }
    { // Code generated by: y | z ~ ContinuousUniform(0.0, z)
      // Construction and addition of the factor/model:
      components.add(
        new blang.distributions.ContinuousUniform(
          $generated__2(z, y, $generated__rate.get()), 
          new $generated__3_class(z), 
          new $generated__4_class(z)
        )
        );
    }
    
    return components;
  }
}
