package jss.gmm;

import blang.core.ConstantSupplier;
import blang.core.DeboxedName;
import blang.core.IntVar;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.Param;
import blang.core.RealVar;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import blang.io.GlobalDataSource;
import blang.types.DenseSimplex;
import blang.types.ExtensionUtils;
import blang.types.Index;
import blang.types.Plate;
import blang.types.Plated;
import blang.types.Simplex;
import blang.types.StaticUtils;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@SuppressWarnings("all")
public class MixtureModelPlated implements Model {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public GlobalDataSource data;
    
    private boolean data_initialized = false;
    
    public MixtureModelPlated.Builder setData(final GlobalDataSource data) {
      data_initialized = true;
      this.data = data;
      return this;
    }
    
    @Arg
    public Optional<Integer> K;
    
    public MixtureModelPlated.Builder setK(final Integer K) {
      // work around typeRef(..) limitation
      Optional<Integer> $generated__dummy = null;
      this.K = Optional.of(K);
      return this;
    }
    
    @Arg
    public Plate<Integer> N;
    
    private boolean N_initialized = false;
    
    public MixtureModelPlated.Builder setN(final Plate<Integer> N) {
      N_initialized = true;
      this.N = N;
      return this;
    }
    
    @Arg
    public Optional<Plate<Integer>> components;
    
    public MixtureModelPlated.Builder setComponents(final Plate<Integer> components) {
      // work around typeRef(..) limitation
      Optional<Plate<Integer>> $generated__dummy = null;
      this.components = Optional.of(components);
      return this;
    }
    
    @Arg
    public Plated<IntVar> z;
    
    private boolean z_initialized = false;
    
    public MixtureModelPlated.Builder setZ(final Plated<IntVar> z) {
      z_initialized = true;
      this.z = z;
      return this;
    }
    
    @Arg
    public Plated<RealVar> y;
    
    private boolean y_initialized = false;
    
    public MixtureModelPlated.Builder setY(final Plated<RealVar> y) {
      y_initialized = true;
      this.y = y;
      return this;
    }
    
    @Arg
    public Plated<RealVar> mu;
    
    private boolean mu_initialized = false;
    
    public MixtureModelPlated.Builder setMu(final Plated<RealVar> mu) {
      mu_initialized = true;
      this.mu = mu;
      return this;
    }
    
    @Arg
    public Plated<RealVar> sd;
    
    private boolean sd_initialized = false;
    
    public MixtureModelPlated.Builder setSd(final Plated<RealVar> sd) {
      sd_initialized = true;
      this.sd = sd;
      return this;
    }
    
    @Arg
    public Optional<Simplex> pi;
    
    public MixtureModelPlated.Builder setPi(final Simplex pi) {
      // work around typeRef(..) limitation
      Optional<Simplex> $generated__dummy = null;
      this.pi = Optional.of(pi);
      return this;
    }
    
    public MixtureModelPlated build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      if (!fromCommandLine && !data_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing data");
      final GlobalDataSource __data = data;
      Integer K;
      if (this.K != null && this.K.isPresent()) {
        K = this.K.get();
      } else {
        K = $generated__19(data);
      }
      final Integer __K = K;
      if (!fromCommandLine && !N_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing N");
      final Plate<Integer> __N = N;
      Plate<Integer> components;
      if (this.components != null && this.components.isPresent()) {
        components = this.components.get();
      } else {
        components = $generated__20(data, K, N);
      }
      final Plate<Integer> __components = components;
      if (!fromCommandLine && !z_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing z");
      final Plated<IntVar> __z = z;
      if (!fromCommandLine && !y_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing y");
      final Plated<RealVar> __y = y;
      if (!fromCommandLine && !mu_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing mu");
      final Plated<RealVar> __mu = mu;
      if (!fromCommandLine && !sd_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing sd");
      final Plated<RealVar> __sd = sd;
      Simplex pi;
      if (this.pi != null && this.pi.isPresent()) {
        pi = this.pi.get();
      } else {
        pi = $generated__21(data, K, N, components, z, y, mu, sd);
      }
      final Simplex __pi = pi;
      // Build the instance after boxing params
      return new MixtureModelPlated(
        __z, 
        __y, 
        __mu, 
        __sd, 
        __pi, 
        new ConstantSupplier(__data), 
        new ConstantSupplier(__K), 
        new ConstantSupplier(__N), 
        new ConstantSupplier(__components)
      );
    }
  }
  
  @DesignatedConstructor
  public static MixtureModelPlated.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  @Param
  private final Supplier<GlobalDataSource> $generated__data;
  
  public GlobalDataSource getData() {
    return $generated__data.get();
  }
  
  @Param
  private final Supplier<Integer> $generated__K;
  
  public Integer getK() {
    return $generated__K.get();
  }
  
  @Param
  private final Supplier<Plate<Integer>> $generated__N;
  
  public Plate<Integer> getN() {
    return $generated__N.get();
  }
  
  @Param
  private final Supplier<Plate<Integer>> $generated__components;
  
  public Plate<Integer> getComponents() {
    return $generated__components.get();
  }
  
  private final Plated<IntVar> z;
  
  public Plated<IntVar> getZ() {
    return z;
  }
  
  private final Plated<RealVar> y;
  
  public Plated<RealVar> getY() {
    return y;
  }
  
  private final Plated<RealVar> mu;
  
  public Plated<RealVar> getMu() {
    return mu;
  }
  
  private final Plated<RealVar> sd;
  
  public Plated<RealVar> getSd() {
    return sd;
  }
  
  private final Simplex pi;
  
  public Simplex getPi() {
    return pi;
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * pi
   */
  private static Simplex $generated__0(final GlobalDataSource data, final Integer K, final Plate<Integer> N, final Plate<Integer> components, final Plated<IntVar> z, final Plated<RealVar> y, final Plated<RealVar> mu, final Plated<RealVar> sd, final Simplex pi) {
    return pi;
  }
  
  /**
   * Auxiliary method generated to translate:
   * K
   */
  private static Integer $generated__1(final Integer K) {
    return K;
  }
  
  public static class $generated__1_class implements Supplier<Integer> {
    public Integer get() {
      return $generated__1($generated__K.get());
    }
    
    public String toString() {
      return "K";
    }
    
    private final Supplier<Integer> $generated__K;
    
    public $generated__1_class(final Supplier<Integer> $generated__K) {
      this.$generated__K = $generated__K;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 1.0
   */
  private static RealVar $generated__2(final Integer K) {
    return new blang.core.RealConstant(1.0);
  }
  
  public static class $generated__2_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__2($generated__K.get());
    }
    
    public String toString() {
      return "1.0";
    }
    
    private final Supplier<Integer> $generated__K;
    
    public $generated__2_class(final Supplier<Integer> $generated__K) {
      this.$generated__K = $generated__K;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * components.indices
   */
  private static Iterable<Index<Integer>> $generated__3(final GlobalDataSource data, final Integer K, final Plate<Integer> N, final Plate<Integer> components, final Plated<IntVar> z, final Plated<RealVar> y, final Plated<RealVar> mu, final Plated<RealVar> sd, final Simplex pi) {
    Collection<Index<Integer>> _indices = components.indices();
    return _indices;
  }
  
  /**
   * Auxiliary method generated to translate:
   * mu.get(k)
   */
  private static RealVar $generated__4(final Index<Integer> k, final GlobalDataSource data, final Integer K, final Plate<Integer> N, final Plate<Integer> components, final Plated<IntVar> z, final Plated<RealVar> y, final Plated<RealVar> mu, final Plated<RealVar> sd, final Simplex pi) {
    RealVar _get = mu.get(k);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 0.0
   */
  private static RealVar $generated__5() {
    return new blang.core.RealConstant(0.0);
  }
  
  public static class $generated__5_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__5();
    }
    
    public String toString() {
      return "0.0";
    }
    
    public $generated__5_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 100.0
   */
  private static RealVar $generated__6() {
    return new blang.core.RealConstant(100.0);
  }
  
  public static class $generated__6_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__6();
    }
    
    public String toString() {
      return "100.0";
    }
    
    public $generated__6_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * sd.get(k)
   */
  private static RealVar $generated__7(final Index<Integer> k, final GlobalDataSource data, final Integer K, final Plate<Integer> N, final Plate<Integer> components, final Plated<IntVar> z, final Plated<RealVar> y, final Plated<RealVar> mu, final Plated<RealVar> sd, final Simplex pi) {
    RealVar _get = sd.get(k);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 0.0
   */
  private static RealVar $generated__8() {
    return new blang.core.RealConstant(0.0);
  }
  
  public static class $generated__8_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__8();
    }
    
    public String toString() {
      return "0.0";
    }
    
    public $generated__8_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 10.0
   */
  private static RealVar $generated__9() {
    return new blang.core.RealConstant(10.0);
  }
  
  public static class $generated__9_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__9();
    }
    
    public String toString() {
      return "10.0";
    }
    
    public $generated__9_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * N.indices
   */
  private static Iterable<Index<Integer>> $generated__10(final GlobalDataSource data, final Integer K, final Plate<Integer> N, final Plate<Integer> components, final Plated<IntVar> z, final Plated<RealVar> y, final Plated<RealVar> mu, final Plated<RealVar> sd, final Simplex pi) {
    Collection<Index<Integer>> _indices = N.indices();
    return _indices;
  }
  
  /**
   * Auxiliary method generated to translate:
   * z.get(i)
   */
  private static IntVar $generated__11(final Index<Integer> i, final GlobalDataSource data, final Integer K, final Plate<Integer> N, final Plate<Integer> components, final Plated<IntVar> z, final Plated<RealVar> y, final Plated<RealVar> mu, final Plated<RealVar> sd, final Simplex pi) {
    IntVar _get = z.get(i);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * pi
   */
  private static Simplex $generated__12(final Simplex pi) {
    return pi;
  }
  
  public static class $generated__12_class implements Supplier<Simplex> {
    public Simplex get() {
      return $generated__12(pi);
    }
    
    public String toString() {
      return "pi";
    }
    
    private final Simplex pi;
    
    public $generated__12_class(final Simplex pi) {
      this.pi = pi;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * mu.asList(components)
   */
  private static List<RealVar> $generated__13(final Index<Integer> i, final GlobalDataSource data, final Integer K, final Plate<Integer> N, final Plate<Integer> components, final Plated<IntVar> z, final Plated<RealVar> y, final Plated<RealVar> mu, final Plated<RealVar> sd, final Simplex pi) {
    List<RealVar> _asList = ExtensionUtils.<RealVar>asList(mu, components);
    return _asList;
  }
  
  /**
   * Auxiliary method generated to translate:
   * sd.asList(components)
   */
  private static List<RealVar> $generated__14(final Index<Integer> i, final GlobalDataSource data, final Integer K, final Plate<Integer> N, final Plate<Integer> components, final Plated<IntVar> z, final Plated<RealVar> y, final Plated<RealVar> mu, final Plated<RealVar> sd, final Simplex pi) {
    List<RealVar> _asList = ExtensionUtils.<RealVar>asList(sd, components);
    return _asList;
  }
  
  /**
   * Auxiliary method generated to translate:
   * z.get(i)
   */
  private static IntVar $generated__15(final Index<Integer> i, final GlobalDataSource data, final Integer K, final Plate<Integer> N, final Plate<Integer> components, final Plated<IntVar> z, final Plated<RealVar> y, final Plated<RealVar> mu, final Plated<RealVar> sd, final Simplex pi) {
    IntVar _get = z.get(i);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * y.get(i)
   */
  private static RealVar $generated__16(final Index<Integer> i, final GlobalDataSource data, final Integer K, final Plate<Integer> N, final Plate<Integer> components, final Plated<IntVar> z, final Plated<RealVar> y, final Plated<RealVar> mu, final Plated<RealVar> sd, final Simplex pi) {
    RealVar _get = y.get(i);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * muList.get(k)
   */
  private static RealVar $generated__17(final List<RealVar> muList, final List<RealVar> sdList, final IntVar k) {
    RealVar _get = muList.get((k).intValue());
    return _get;
  }
  
  public static class $generated__17_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__17(muList, sdList, k);
    }
    
    public String toString() {
      return "muList.get(k)";
    }
    
    private final List<RealVar> muList;
    
    private final List<RealVar> sdList;
    
    private final IntVar k;
    
    public $generated__17_class(final List<RealVar> muList, final List<RealVar> sdList, final IntVar k) {
      this.muList = muList;
      this.sdList = sdList;
      this.k = k;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * pow(sdList.get(k), 2.0)
   */
  private static RealVar $generated__18(final List<RealVar> muList, final List<RealVar> sdList, final IntVar k) {
    double _pow = Math.pow((sdList.get((k).intValue())).doubleValue(), 2.0);
    return new blang.core.RealConstant(_pow);
  }
  
  public static class $generated__18_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__18(muList, sdList, k);
    }
    
    public String toString() {
      return "pow(sdList.get(k), 2.0)";
    }
    
    private final List<RealVar> muList;
    
    private final List<RealVar> sdList;
    
    private final IntVar k;
    
    public $generated__18_class(final List<RealVar> muList, final List<RealVar> sdList, final IntVar k) {
      this.muList = muList;
      this.sdList = sdList;
      this.k = k;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 2
   */
  private static Integer $generated__19(final GlobalDataSource data) {
    return Integer.valueOf(2);
  }
  
  /**
   * Auxiliary method generated to translate:
   * Plate.ofIntegers("components", K)
   */
  private static Plate<Integer> $generated__20(final GlobalDataSource data, final Integer K, final Plate<Integer> N) {
    Plate<Integer> _ofIntegers = Plate.ofIntegers("components", (K).intValue());
    return _ofIntegers;
  }
  
  /**
   * Auxiliary method generated to translate:
   * latentSimplex(K)
   */
  private static Simplex $generated__21(final GlobalDataSource data, final Integer K, final Plate<Integer> N, final Plate<Integer> components, final Plated<IntVar> z, final Plated<RealVar> y, final Plated<RealVar> mu, final Plated<RealVar> sd) {
    DenseSimplex _latentSimplex = StaticUtils.latentSimplex((K).intValue());
    return _latentSimplex;
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public MixtureModelPlated(@DeboxedName("z") final Plated<IntVar> z, @DeboxedName("y") final Plated<RealVar> y, @DeboxedName("mu") final Plated<RealVar> mu, @DeboxedName("sd") final Plated<RealVar> sd, @DeboxedName("pi") final Simplex pi, @Param @DeboxedName("data") final Supplier<GlobalDataSource> $generated__data, @Param @DeboxedName("K") final Supplier<Integer> $generated__K, @Param @DeboxedName("N") final Supplier<Plate<Integer>> $generated__N, @Param @DeboxedName("components") final Supplier<Plate<Integer>> $generated__components) {
    this.$generated__data = $generated__data;
    this.$generated__K = $generated__K;
    this.$generated__N = $generated__N;
    this.$generated__components = $generated__components;
    this.z = z;
    this.y = y;
    this.mu = mu;
    this.sd = sd;
    this.pi = pi;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    { // Code generated by: pi | K ~ SymmetricDirichlet(K, 1.0)
      // Construction and addition of the factor/model:
      components.add(
        new blang.distributions.SymmetricDirichlet(
          $generated__0($generated__data.get(), $generated__K.get(), $generated__N.get(), $generated__components.get(), z, y, mu, sd, pi), 
          new $generated__1_class($generated__K), 
          new $generated__2_class($generated__K)
        )
        );
    }
    for (Index<Integer> k : $generated__3($generated__data.get(), $generated__K.get(), $generated__N.get(), $generated__components.get(), z, y, mu, sd, pi)) {
      { // Code generated by: mu.get(k) ~ Normal(0.0, 100.0)
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.Normal(
            $generated__4(k, $generated__data.get(), $generated__K.get(), $generated__N.get(), $generated__components.get(), z, y, mu, sd, pi), 
            new $generated__5_class(), 
            new $generated__6_class()
          )
          );
      }
      { // Code generated by: sd.get(k) ~ ContinuousUniform(0.0 ,10.0)
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.ContinuousUniform(
            $generated__7(k, $generated__data.get(), $generated__K.get(), $generated__N.get(), $generated__components.get(), z, y, mu, sd, pi), 
            new $generated__8_class(), 
            new $generated__9_class()
          )
          );
      }
    }
    for (Index<Integer> i : $generated__10($generated__data.get(), $generated__K.get(), $generated__N.get(), $generated__components.get(), z, y, mu, sd, pi)) {
      { // Code generated by: z.get(i) | pi ~ Categorical(pi)
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.Categorical(
            $generated__11(i, $generated__data.get(), $generated__K.get(), $generated__N.get(), $generated__components.get(), z, y, mu, sd, pi), 
            new $generated__12_class(pi)
          )
          );
      }
      { // Code generated by: y.get(i) | List<RealVar> muList = mu.asList(components), List<RealVar> sdList = sd.asList(components), IntVar k = z.get(i) ~ Normal(muList.get(k) , pow(sdList.get(k), 2.0))
        // Required initialization:
        List<RealVar> muList = $generated__13(i, $generated__data.get(), $generated__K.get(), $generated__N.get(), $generated__components.get(), z, y, mu, sd, pi);
        List<RealVar> sdList = $generated__14(i, $generated__data.get(), $generated__K.get(), $generated__N.get(), $generated__components.get(), z, y, mu, sd, pi);
        IntVar k = $generated__15(i, $generated__data.get(), $generated__K.get(), $generated__N.get(), $generated__components.get(), z, y, mu, sd, pi);
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.Normal(
            $generated__16(i, $generated__data.get(), $generated__K.get(), $generated__N.get(), $generated__components.get(), z, y, mu, sd, pi), 
            new $generated__17_class(muList, sdList, k), 
            new $generated__18_class(muList, sdList, k)
          )
          );
      }
    }
    
    return components;
  }
}
