package jss.others;

import blang.core.ConstantSupplier;
import blang.core.DeboxedName;
import blang.core.Distribution;
import blang.core.DistributionAdaptor;
import blang.core.ForwardSimulator;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.Param;
import blang.core.RealDistribution;
import blang.core.RealDistributionAdaptor;
import blang.core.RealVar;
import blang.core.UnivariateModel;
import blang.core.WritableRealVar;
import blang.distributions.Generators;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Supplier;

@SuppressWarnings("all")
public class ExponentialExample implements Model, UnivariateModel<RealVar>, ForwardSimulator {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public RealVar realization;
    
    private boolean realization_initialized = false;
    
    public ExponentialExample.Builder setRealization(final RealVar realization) {
      realization_initialized = true;
      this.realization = realization;
      return this;
    }
    
    @Arg
    public RealVar rate;
    
    private boolean rate_initialized = false;
    
    public ExponentialExample.Builder setRate(final RealVar rate) {
      rate_initialized = true;
      this.rate = rate;
      return this;
    }
    
    public ExponentialExample build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      if (!fromCommandLine && !realization_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing realization");
      final RealVar __realization = realization;
      if (!fromCommandLine && !rate_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing rate");
      final RealVar __rate = rate;
      // Build the instance after boxing params
      return new ExponentialExample(
        __realization, 
        new ConstantSupplier(__rate)
      );
    }
  }
  
  @DesignatedConstructor
  public static ExponentialExample.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  private final RealVar realization;
  
  public RealVar getRealization() {
    return realization;
  }
  
  @Param
  private final Supplier<RealVar> $generated__rate;
  
  public RealVar getRate() {
    return $generated__rate.get();
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * realization
   */
  private static RealVar $generated__0(final RealVar realization, final RealVar rate) {
    return realization;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 1.0
   */
  private static RealVar $generated__1(final RealVar rate) {
    return new blang.core.RealConstant(1.0);
  }
  
  public static class $generated__1_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__1($generated__rate.get());
    }
    
    public String toString() {
      return "1.0";
    }
    
    private final Supplier<RealVar> $generated__rate;
    
    public $generated__1_class(final Supplier<RealVar> $generated__rate) {
      this.$generated__rate = $generated__rate;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * rate
   */
  private static RealVar $generated__2(final RealVar rate) {
    return rate;
  }
  
  public static class $generated__2_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__2($generated__rate.get());
    }
    
    public String toString() {
      return "rate";
    }
    
    private final Supplier<RealVar> $generated__rate;
    
    public $generated__2_class(final Supplier<RealVar> $generated__rate) {
      this.$generated__rate = $generated__rate;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * { rand.exponential(rate) }
   */
  private static Double $generated__3(final Random rand, final RealVar realization, final RealVar rate) {
    return Double.valueOf(Generators.exponential(rand, (rate).doubleValue()));
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public ExponentialExample(@DeboxedName("realization") final RealVar realization, @Param @DeboxedName("rate") final Supplier<RealVar> $generated__rate) {
    this.realization = realization;
    this.$generated__rate = $generated__rate;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    { // Code generated by: realization | rate ~ Gamma(1.0, rate)
      // Construction and addition of the factor/model:
      components.add(
        new blang.distributions.Gamma(
          $generated__0(realization, $generated__rate.get()), 
          new $generated__1_class($generated__rate), 
          new $generated__2_class($generated__rate)
        )
        );
    }
    
    return components;
  }
  
  public void generate(final Random rand) {
    ((WritableRealVar) realization).set(
      $generated__3(rand, realization, $generated__rate.get())
    );
  }
  
  public RealVar realization() {
    return realization;
  }
  
  /**
   * Returns an instance with fixed parameters values and conforming the Distribution interface. 
   * Useful when passing around distributions as parameters, e.g. for Dirichlet Process mixtures. 
   * 
   */
  public static RealDistribution distribution(@Param final RealVar rate) {
    UnivariateModel<RealVar> univariateModel = new ExponentialExample(
      new RealDistributionAdaptor.WritableRealVarImpl(), 
      new ConstantSupplier(rate)
    );
    Distribution<RealVar> distribution = new DistributionAdaptor(univariateModel);
    return new RealDistributionAdaptor(distribution);
  }
}
