package jss.glms;

import blang.core.RealVar;
import blang.types.Index;
import blang.types.Plate;
import blang.types.Plated;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SuppressWarnings("all")
public class DotProduct {
  private final List<RealVar> parameters = new ArrayList<RealVar>();
  
  private final List<Double> covariates = new ArrayList<Double>();
  
  public static <T extends Object> DotProduct of(final Plate<T> features, final Plated<? extends RealVar> parameters, final Plated<? extends Number> covariates) {
    final DotProduct result = new DotProduct();
    Collection<Index<T>> _indices = features.indices();
    for (final Index<T> feature : _indices) {
      {
        final double covariate = covariates.get(feature).doubleValue();
        if (((covariate != 0.0) && (covariate != (-0.0)))) {
          result.covariates.add(Double.valueOf(covariate));
          result.parameters.add(parameters.get(feature));
        }
      }
    }
    return result;
  }
  
  public double compute() {
    double result = 0.0;
    for (int i = 0; (i < this.parameters.size()); i++) {
      double _result = result;
      double _doubleValue = this.parameters.get(i).doubleValue();
      Double _get = this.covariates.get(i);
      double _multiply = (_doubleValue * (_get).doubleValue());
      result = (_result + _multiply);
    }
    return result;
  }
}
