package jss.others;

import blang.core.ConstantSupplier;
import blang.core.DeboxedName;
import blang.core.Distribution;
import blang.core.DistributionAdaptor;
import blang.core.ForwardSimulator;
import blang.core.LogScaleFactor;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.Param;
import blang.core.RealDistribution;
import blang.core.RealDistributionAdaptor;
import blang.core.RealVar;
import blang.core.UnivariateModel;
import blang.core.WritableRealVar;
import blang.distributions.Generators;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import blang.types.StaticUtils;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Supplier;

@SuppressWarnings("all")
public class ContinuousUniformExample implements Model, UnivariateModel<RealVar>, ForwardSimulator {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public RealVar realization;
    
    private boolean realization_initialized = false;
    
    public ContinuousUniformExample.Builder setRealization(final RealVar realization) {
      realization_initialized = true;
      this.realization = realization;
      return this;
    }
    
    @Arg
    public RealVar min;
    
    private boolean min_initialized = false;
    
    public ContinuousUniformExample.Builder setMin(final RealVar min) {
      min_initialized = true;
      this.min = min;
      return this;
    }
    
    @Arg
    public RealVar max;
    
    private boolean max_initialized = false;
    
    public ContinuousUniformExample.Builder setMax(final RealVar max) {
      max_initialized = true;
      this.max = max;
      return this;
    }
    
    public ContinuousUniformExample build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      if (!fromCommandLine && !realization_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing realization");
      final RealVar __realization = realization;
      if (!fromCommandLine && !min_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing min");
      final RealVar __min = min;
      if (!fromCommandLine && !max_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing max");
      final RealVar __max = max;
      // Build the instance after boxing params
      return new ContinuousUniformExample(
        __realization, 
        new ConstantSupplier(__min), 
        new ConstantSupplier(__max)
      );
    }
  }
  
  @DesignatedConstructor
  public static ContinuousUniformExample.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  private final RealVar realization;
  
  public RealVar getRealization() {
    return realization;
  }
  
  @Param
  private final Supplier<RealVar> $generated__min;
  
  public RealVar getMin() {
    return $generated__min.get();
  }
  
  @Param
  private final Supplier<RealVar> $generated__max;
  
  public RealVar getMax() {
    return $generated__max.get();
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * { if (max - min <= 0.0) return NEGATIVE_INFINITY return - log(max - min) }
   */
  private static double $generated__0(final RealVar min, final RealVar max) {
    if ((((max).doubleValue() - (min).doubleValue()) <= 0.0)) {
      return StaticUtils.NEGATIVE_INFINITY();
    }
    double _log = Math.log(((max).doubleValue() - (min).doubleValue()));
    return (-_log);
  }
  
  public static class $generated__0_class implements LogScaleFactor {
    public double logDensity() {
      return $generated__0($generated__min.get(), $generated__max.get());
    }
    
    public String toString() {
      return "{ if (max - min <= 0.0) return NEGATIVE_INFINITY return - log(max - min) }";
    }
    
    private final Supplier<RealVar> $generated__min;
    
    private final Supplier<RealVar> $generated__max;
    
    public $generated__0_class(final Supplier<RealVar> $generated__min, final Supplier<RealVar> $generated__max) {
      this.$generated__min = $generated__min;
      this.$generated__max = $generated__max;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * { if (min <= realization && realization <= max) return 0.0 else return NEGATIVE_INFINITY }
   */
  private static double $generated__1(final RealVar realization, final RealVar min, final RealVar max) {
    if ((((min).doubleValue() <= (realization).doubleValue()) && ((realization).doubleValue() <= (max).doubleValue()))) {
      return 0.0;
    } else {
      return StaticUtils.NEGATIVE_INFINITY();
    }
  }
  
  public static class $generated__1_class implements LogScaleFactor {
    public double logDensity() {
      return $generated__1(realization, $generated__min.get(), $generated__max.get());
    }
    
    public String toString() {
      return "{ if (min <= realization && realization <= max) return 0.0 else return NEGATIVE_INFINITY }";
    }
    
    private final RealVar realization;
    
    private final Supplier<RealVar> $generated__min;
    
    private final Supplier<RealVar> $generated__max;
    
    public $generated__1_class(final RealVar realization, final Supplier<RealVar> $generated__min, final Supplier<RealVar> $generated__max) {
      this.realization = realization;
      this.$generated__min = $generated__min;
      this.$generated__max = $generated__max;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * { rand.uniform(min, max) }
   */
  private static Double $generated__2(final Random rand, final RealVar realization, final RealVar min, final RealVar max) {
    return Double.valueOf(Generators.uniform(rand, (min).doubleValue(), (max).doubleValue()));
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public ContinuousUniformExample(@DeboxedName("realization") final RealVar realization, @Param @DeboxedName("min") final Supplier<RealVar> $generated__min, @Param @DeboxedName("max") final Supplier<RealVar> $generated__max) {
    this.realization = realization;
    this.$generated__min = $generated__min;
    this.$generated__max = $generated__max;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    { // Code generated by: (min, max) { if (max - min <= 0.0) return NEGATIVE_INFINITY return - log(max - min) }
      // Construction and addition of the factor/model:
      components.add(
        new $generated__0_class($generated__min, $generated__max));
    }
    { // Code generated by: (realization, min, max) { if (min <= realization && realization <= max) return 0.0 else return NEGATIVE_INFINITY }
      // Construction and addition of the factor/model:
      components.add(
        new $generated__1_class(realization, $generated__min, $generated__max));
    }
    
    return components;
  }
  
  public void generate(final Random rand) {
    ((WritableRealVar) realization).set(
      $generated__2(rand, realization, $generated__min.get(), $generated__max.get())
    );
  }
  
  public RealVar realization() {
    return realization;
  }
  
  /**
   * Returns an instance with fixed parameters values and conforming the Distribution interface. 
   * Useful when passing around distributions as parameters, e.g. for Dirichlet Process mixtures. 
   * 
   */
  public static RealDistribution distribution(@Param final RealVar min, @Param final RealVar max) {
    UnivariateModel<RealVar> univariateModel = new ContinuousUniformExample(
      new RealDistributionAdaptor.WritableRealVarImpl(), 
      new ConstantSupplier(min), 
      new ConstantSupplier(max)
    );
    Distribution<RealVar> distribution = new DistributionAdaptor(univariateModel);
    return new RealDistributionAdaptor(distribution);
  }
}
