package jss.others;

import bayonet.math.SpecialFunctions;
import blang.core.ConstantSupplier;
import blang.core.DeboxedName;
import blang.core.Distribution;
import blang.core.DistributionAdaptor;
import blang.core.IntVar;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.Param;
import blang.core.RealVar;
import blang.core.UnivariateModel;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import blang.types.StaticUtils;
import blang.validation.internals.fixtures.Functions;
import briefj.collections.UnorderedPair;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@SuppressWarnings("all")
public class IsingExample implements Model, UnivariateModel<List<IntVar>> {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public Optional<Double> moment;
    
    public IsingExample.Builder setMoment(final Double moment) {
      // work around typeRef(..) limitation
      Optional<Double> $generated__dummy = null;
      this.moment = Optional.of(moment);
      return this;
    }
    
    @Arg
    public Optional<Double> beta;
    
    public IsingExample.Builder setBeta(final Double beta) {
      // work around typeRef(..) limitation
      Optional<Double> $generated__dummy = null;
      this.beta = Optional.of(beta);
      return this;
    }
    
    @Arg
    public Optional<Integer> N;
    
    public IsingExample.Builder setN(final Integer N) {
      // work around typeRef(..) limitation
      Optional<Integer> $generated__dummy = null;
      this.N = Optional.of(N);
      return this;
    }
    
    @Arg
    public Optional<List<IntVar>> vertices;
    
    public IsingExample.Builder setVertices(final List<IntVar> vertices) {
      // work around typeRef(..) limitation
      Optional<List<IntVar>> $generated__dummy = null;
      this.vertices = Optional.of(vertices);
      return this;
    }
    
    public IsingExample build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      Double moment;
      if (this.moment != null && this.moment.isPresent()) {
        moment = this.moment.get();
      } else {
        moment = $generated__7();
      }
      final Double __moment = moment;
      Double beta;
      if (this.beta != null && this.beta.isPresent()) {
        beta = this.beta.get();
      } else {
        beta = $generated__8(moment);
      }
      final Double __beta = beta;
      Integer N;
      if (this.N != null && this.N.isPresent()) {
        N = this.N.get();
      } else {
        N = $generated__9(moment, beta);
      }
      final Integer __N = N;
      List<IntVar> vertices;
      if (this.vertices != null && this.vertices.isPresent()) {
        vertices = this.vertices.get();
      } else {
        vertices = $generated__10(moment, beta, N);
      }
      final List<IntVar> __vertices = vertices;
      // Build the instance after boxing params
      return new IsingExample(
        __vertices, 
        new ConstantSupplier(__moment), 
        new ConstantSupplier(__beta), 
        new ConstantSupplier(__N)
      );
    }
  }
  
  @DesignatedConstructor
  public static IsingExample.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  @Param
  private final Supplier<Double> $generated__moment;
  
  public Double getMoment() {
    return $generated__moment.get();
  }
  
  @Param
  private final Supplier<Double> $generated__beta;
  
  public Double getBeta() {
    return $generated__beta.get();
  }
  
  @Param
  private final Supplier<Integer> $generated__N;
  
  public Integer getN() {
    return $generated__N.get();
  }
  
  private final List<IntVar> vertices;
  
  public List<IntVar> getVertices() {
    return vertices;
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * squareIsingEdges(N)
   */
  private static Iterable<UnorderedPair<Integer, Integer>> $generated__0(final Double moment, final Double beta, final Integer N, final List<IntVar> vertices) {
    List<UnorderedPair<Integer, Integer>> _squareIsingEdges = Functions.squareIsingEdges((N).intValue());
    return _squareIsingEdges;
  }
  
  /**
   * Auxiliary method generated to translate:
   * vertices.get(pair.getFirst)
   */
  private static IntVar $generated__1(final UnorderedPair<Integer, Integer> pair, final Double moment, final Double beta, final Integer N, final List<IntVar> vertices) {
    IntVar _get = vertices.get((pair.getFirst()).intValue());
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * vertices.get(pair.getSecond)
   */
  private static IntVar $generated__2(final UnorderedPair<Integer, Integer> pair, final Double moment, final Double beta, final Integer N, final List<IntVar> vertices) {
    IntVar _get = vertices.get((pair.getSecond()).intValue());
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * if ((first < 0 || first > 1 || second < 0 || second > 1)) return NEGATIVE_INFINITY else return beta*(2*first-1)*(2*second-1)
   */
  private static RealVar $generated__3(final IntVar first, final IntVar second, final Double beta) {
    if ((((((first).intValue() < 0) || ((first).intValue() > 1)) || ((second).intValue() < 0)) || ((second).intValue() > 1))) {
      return new blang.core.RealConstant(StaticUtils.NEGATIVE_INFINITY());
    } else {
      return new blang.core.RealConstant((((beta).doubleValue() * ((2 * (first).intValue()) - 1)) * ((2 * (second).intValue()) - 1)));
    }
  }
  
  public static class $generated__3_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__3(first, second, $generated__beta.get());
    }
    
    public String toString() {
      return "if ((first < 0 || first > 1 || second < 0 || second > 1)) return NEGATIVE_INFINITY else return beta*(2*first-1)*(2*second-1)";
    }
    
    private final IntVar first;
    
    private final IntVar second;
    
    private final Supplier<Double> $generated__beta;
    
    public $generated__3_class(final IntVar first, final IntVar second, final Supplier<Double> $generated__beta) {
      this.first = first;
      this.second = second;
      this.$generated__beta = $generated__beta;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * vertices
   */
  private static Iterable<IntVar> $generated__4(final Double moment, final Double beta, final Integer N, final List<IntVar> vertices) {
    return vertices;
  }
  
  /**
   * Auxiliary method generated to translate:
   * vertex
   */
  private static IntVar $generated__5(final IntVar vertex, final Double moment, final Double beta, final Integer N, final List<IntVar> vertices) {
    return vertex;
  }
  
  /**
   * Auxiliary method generated to translate:
   * logistic(-2.0*moment)
   */
  private static RealVar $generated__6(final Double moment) {
    double _logistic = SpecialFunctions.logistic(((-2.0) * (moment).doubleValue()));
    return new blang.core.RealConstant(_logistic);
  }
  
  public static class $generated__6_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__6($generated__moment.get());
    }
    
    public String toString() {
      return "logistic(-2.0*moment)";
    }
    
    private final Supplier<Double> $generated__moment;
    
    public $generated__6_class(final Supplier<Double> $generated__moment) {
      this.$generated__moment = $generated__moment;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 0.0
   */
  private static Double $generated__7() {
    return Double.valueOf(0.0);
  }
  
  /**
   * Auxiliary method generated to translate:
   * log(1 + sqrt(2.0)) / 2.0
   */
  private static Double $generated__8(final Double moment) {
    double _sqrt = Math.sqrt(2.0);
    double _plus = (1 + _sqrt);
    double _log = Math.log(_plus);
    double _divide = (_log / 2.0);
    return Double.valueOf(_divide);
  }
  
  /**
   * Auxiliary method generated to translate:
   * 3
   */
  private static Integer $generated__9(final Double moment, final Double beta) {
    return Integer.valueOf(3);
  }
  
  /**
   * Auxiliary method generated to translate:
   * latentIntList(N*N)
   */
  private static List<IntVar> $generated__10(final Double moment, final Double beta, final Integer N) {
    List<IntVar> _latentIntList = StaticUtils.latentIntList(((N).intValue() * (N).intValue()));
    return _latentIntList;
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public IsingExample(@DeboxedName("vertices") final List<IntVar> vertices, @Param @DeboxedName("moment") final Supplier<Double> $generated__moment, @Param @DeboxedName("beta") final Supplier<Double> $generated__beta, @Param @DeboxedName("N") final Supplier<Integer> $generated__N) {
    this.$generated__moment = $generated__moment;
    this.$generated__beta = $generated__beta;
    this.$generated__N = $generated__N;
    this.vertices = vertices;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    for (UnorderedPair<Integer, Integer> pair : $generated__0($generated__moment.get(), $generated__beta.get(), $generated__N.get(), vertices)) {
      { // Code generated by: | IntVar first = vertices.get(pair.getFirst), IntVar second = vertices.get(pair.getSecond), beta ~ LogPotentialExample( if ((first < 0 || first > 1 || second < 0 || second > 1)) return NEGATIVE_INFINITY else return beta*(2*first-1)*(2*second-1))
        // Required initialization:
        IntVar first = $generated__1(pair, $generated__moment.get(), $generated__beta.get(), $generated__N.get(), vertices);
        IntVar second = $generated__2(pair, $generated__moment.get(), $generated__beta.get(), $generated__N.get(), vertices);
        // Construction and addition of the factor/model:
        components.add(
          new jss.others.LogPotentialExample(
            new $generated__3_class(first, second, $generated__beta)
          )
          );
      }
    }
    for (IntVar vertex : $generated__4($generated__moment.get(), $generated__beta.get(), $generated__N.get(), vertices)) {
      { // Code generated by: vertex | moment ~ Bernoulli(logistic(-2.0*moment))
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.Bernoulli(
            $generated__5(vertex, $generated__moment.get(), $generated__beta.get(), $generated__N.get(), vertices), 
            new $generated__6_class($generated__moment)
          )
          );
      }
    }
    
    return components;
  }
  
  public List<IntVar> realization() {
    return vertices;
  }
  
  /**
   * Returns an instance with fixed parameters values and conforming the Distribution interface. 
   * Useful when passing around distributions as parameters, e.g. for Dirichlet Process mixtures. 
   * 
   */
  public static Distribution<List<IntVar>> distribution(final List<IntVar> vertices, @Param final Double moment, @Param final Double beta, @Param final Integer N) {
    UnivariateModel<List<IntVar>> univariateModel = new IsingExample(
      vertices, 
      new ConstantSupplier(moment), 
      new ConstantSupplier(beta), 
      new ConstantSupplier(N)
    );
    Distribution<List<IntVar>> distribution = new DistributionAdaptor(univariateModel);
    return distribution;
  }
}
