package jss.others;

import blang.core.ConstantSupplier;
import blang.core.DeboxedName;
import blang.core.Distribution;
import blang.core.DistributionAdaptor;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.Param;
import blang.core.UnivariateModel;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import blang.types.Index;
import blang.types.Plate;
import blang.types.PlatedMatrix;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import xlinear.CholeskyDecomposition;
import xlinear.DenseMatrix;
import xlinear.Matrix;
import xlinear.MatrixOperations;

@SuppressWarnings("all")
public class PlatedMatrixExample implements Model, UnivariateModel<PlatedMatrix> {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public Plate<String> dims;
    
    private boolean dims_initialized = false;
    
    public PlatedMatrixExample.Builder setDims(final Plate<String> dims) {
      dims_initialized = true;
      this.dims = dims;
      return this;
    }
    
    @Arg
    public Plate<String> replicates;
    
    private boolean replicates_initialized = false;
    
    public PlatedMatrixExample.Builder setReplicates(final Plate<String> replicates) {
      replicates_initialized = true;
      this.replicates = replicates;
      return this;
    }
    
    @Arg
    public PlatedMatrix vectors;
    
    private boolean vectors_initialized = false;
    
    public PlatedMatrixExample.Builder setVectors(final PlatedMatrix vectors) {
      vectors_initialized = true;
      this.vectors = vectors;
      return this;
    }
    
    public PlatedMatrixExample build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      if (!fromCommandLine && !dims_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing dims");
      final Plate<String> __dims = dims;
      if (!fromCommandLine && !replicates_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing replicates");
      final Plate<String> __replicates = replicates;
      if (!fromCommandLine && !vectors_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing vectors");
      final PlatedMatrix __vectors = vectors;
      // Build the instance after boxing params
      return new PlatedMatrixExample(
        __vectors, 
        new ConstantSupplier(__dims), 
        new ConstantSupplier(__replicates)
      );
    }
  }
  
  @DesignatedConstructor
  public static PlatedMatrixExample.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  @Param
  private final Supplier<Plate<String>> $generated__dims;
  
  public Plate<String> getDims() {
    return $generated__dims.get();
  }
  
  @Param
  private final Supplier<Plate<String>> $generated__replicates;
  
  public Plate<String> getReplicates() {
    return $generated__replicates.get();
  }
  
  private final PlatedMatrix vectors;
  
  public PlatedMatrix getVectors() {
    return vectors;
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * replicates.indices
   */
  private static Iterable<Index<String>> $generated__0(final Plate<String> dims, final Plate<String> replicates, final PlatedMatrix vectors) {
    Collection<Index<String>> _indices = replicates.indices();
    return _indices;
  }
  
  /**
   * Auxiliary method generated to translate:
   * vectors.getDenseVector(dims, n)
   */
  private static Matrix $generated__1(final Index<String> n, final Plate<String> dims, final Plate<String> replicates, final PlatedMatrix vectors) {
    DenseMatrix _denseVector = vectors.getDenseVector(dims, n);
    return _denseVector;
  }
  
  /**
   * Auxiliary method generated to translate:
   * ones(3)
   */
  private static Matrix $generated__2() {
    DenseMatrix _ones = MatrixOperations.ones(3);
    return _ones;
  }
  
  public static class $generated__2_class implements Supplier<Matrix> {
    public Matrix get() {
      return $generated__2();
    }
    
    public String toString() {
      return "ones(3)";
    }
    
    public $generated__2_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * identity(3).cholesky
   */
  private static CholeskyDecomposition $generated__3() {
    CholeskyDecomposition _cholesky = MatrixOperations.identity(3).cholesky();
    return _cholesky;
  }
  
  public static class $generated__3_class implements Supplier<CholeskyDecomposition> {
    public CholeskyDecomposition get() {
      return $generated__3();
    }
    
    public String toString() {
      return "identity(3).cholesky";
    }
    
    public $generated__3_class() {
      
    }
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public PlatedMatrixExample(@DeboxedName("vectors") final PlatedMatrix vectors, @Param @DeboxedName("dims") final Supplier<Plate<String>> $generated__dims, @Param @DeboxedName("replicates") final Supplier<Plate<String>> $generated__replicates) {
    this.$generated__dims = $generated__dims;
    this.$generated__replicates = $generated__replicates;
    this.vectors = vectors;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    for (Index<String> n : $generated__0($generated__dims.get(), $generated__replicates.get(), vectors)) {
      { // Code generated by: vectors.getDenseVector(dims, n) ~ MultivariateNormal(ones(3), identity(3).cholesky)
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.MultivariateNormal(
            $generated__1(n, $generated__dims.get(), $generated__replicates.get(), vectors), 
            new $generated__2_class(), 
            new $generated__3_class()
          )
          );
      }
    }
    
    return components;
  }
  
  public PlatedMatrix realization() {
    return vectors;
  }
  
  /**
   * Returns an instance with fixed parameters values and conforming the Distribution interface. 
   * Useful when passing around distributions as parameters, e.g. for Dirichlet Process mixtures. 
   * 
   */
  public static Distribution<PlatedMatrix> distribution(final PlatedMatrix vectors, @Param final Plate<String> dims, @Param final Plate<String> replicates) {
    UnivariateModel<PlatedMatrix> univariateModel = new PlatedMatrixExample(
      vectors, 
      new ConstantSupplier(dims), 
      new ConstantSupplier(replicates)
    );
    Distribution<PlatedMatrix> distribution = new DistributionAdaptor(univariateModel);
    return distribution;
  }
}
