package jss.perm;

import bayonet.math.SpecialFunctions;
import blang.core.DeboxedName;
import blang.core.Distribution;
import blang.core.DistributionAdaptor;
import blang.core.ForwardSimulator;
import blang.core.LogScaleFactor;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.UnivariateModel;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@SuppressWarnings("all")
public class UniformPermutation implements Model, UnivariateModel<Permutation>, ForwardSimulator {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public Permutation permutation;
    
    private boolean permutation_initialized = false;
    
    public UniformPermutation.Builder setPermutation(final Permutation permutation) {
      permutation_initialized = true;
      this.permutation = permutation;
      return this;
    }
    
    public UniformPermutation build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      if (!fromCommandLine && !permutation_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing permutation");
      final Permutation __permutation = permutation;
      // Build the instance after boxing params
      return new UniformPermutation(
        __permutation
      );
    }
  }
  
  @DesignatedConstructor
  public static UniformPermutation.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  private final Permutation permutation;
  
  public Permutation getPermutation() {
    return permutation;
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * { - logFactorial(permutation.componentSize) }
   */
  private static double $generated__0(final Permutation permutation) {
    double _logFactorial = SpecialFunctions.logFactorial(permutation.componentSize());
    return (-_logFactorial);
  }
  
  public static class $generated__0_class implements LogScaleFactor {
    public double logDensity() {
      return $generated__0(permutation);
    }
    
    public String toString() {
      return "{ - logFactorial(permutation.componentSize) }";
    }
    
    private final Permutation permutation;
    
    public $generated__0_class(final Permutation permutation) {
      this.permutation = permutation;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * { permutation.sampleUniform(rand) }
   */
  private static void $generated__1(final Random rand, final Permutation permutation) {
    permutation.sampleUniform(rand);
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public UniformPermutation(@DeboxedName("permutation") final Permutation permutation) {
    this.permutation = permutation;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    { // Code generated by: (permutation) { - logFactorial(permutation.componentSize) }
      // Construction and addition of the factor/model:
      components.add(
        new $generated__0_class(permutation));
    }
    
    return components;
  }
  
  public void generate(final Random rand) {
    $generated__1(rand, permutation);
  }
  
  public Permutation realization() {
    return permutation;
  }
  
  /**
   * Returns an instance with fixed parameters values and conforming the Distribution interface. 
   * Useful when passing around distributions as parameters, e.g. for Dirichlet Process mixtures. 
   * 
   */
  public static Distribution<Permutation> distribution(final Permutation permutation) {
    UnivariateModel<Permutation> univariateModel = new UniformPermutation(
      permutation
    );
    Distribution<Permutation> distribution = new DistributionAdaptor(univariateModel);
    return distribution;
  }
}
