package jss.gmm;

import blang.core.ConstantSupplier;
import blang.core.DeboxedName;
import blang.core.IntVar;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.Param;
import blang.core.RealVar;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import blang.types.DenseSimplex;
import blang.types.Simplex;
import blang.types.StaticUtils;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import xlinear.DenseMatrix;
import xlinear.Matrix;

@SuppressWarnings("all")
public class MixtureModel implements Model {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public List<RealVar> y;
    
    private boolean y_initialized = false;
    
    public MixtureModel.Builder setY(final List<RealVar> y) {
      y_initialized = true;
      this.y = y;
      return this;
    }
    
    @Arg
    public Optional<Integer> n;
    
    public MixtureModel.Builder setN(final Integer n) {
      // work around typeRef(..) limitation
      Optional<Integer> $generated__dummy = null;
      this.n = Optional.of(n);
      return this;
    }
    
    @Arg
    public Optional<Matrix> a;
    
    public MixtureModel.Builder setA(final Matrix a) {
      // work around typeRef(..) limitation
      Optional<Matrix> $generated__dummy = null;
      this.a = Optional.of(a);
      return this;
    }
    
    @Arg
    public Optional<List<IntVar>> z;
    
    public MixtureModel.Builder setZ(final List<IntVar> z) {
      // work around typeRef(..) limitation
      Optional<List<IntVar>> $generated__dummy = null;
      this.z = Optional.of(z);
      return this;
    }
    
    @Arg
    public Optional<Integer> K;
    
    public MixtureModel.Builder setK(final Integer K) {
      // work around typeRef(..) limitation
      Optional<Integer> $generated__dummy = null;
      this.K = Optional.of(K);
      return this;
    }
    
    @Arg
    public Optional<Simplex> pi;
    
    public MixtureModel.Builder setPi(final Simplex pi) {
      // work around typeRef(..) limitation
      Optional<Simplex> $generated__dummy = null;
      this.pi = Optional.of(pi);
      return this;
    }
    
    @Arg
    public Optional<List<RealVar>> mu;
    
    public MixtureModel.Builder setMu(final List<RealVar> mu) {
      // work around typeRef(..) limitation
      Optional<List<RealVar>> $generated__dummy = null;
      this.mu = Optional.of(mu);
      return this;
    }
    
    @Arg
    public Optional<List<RealVar>> sd;
    
    public MixtureModel.Builder setSd(final List<RealVar> sd) {
      // work around typeRef(..) limitation
      Optional<List<RealVar>> $generated__dummy = null;
      this.sd = Optional.of(sd);
      return this;
    }
    
    public MixtureModel build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      if (!fromCommandLine && !y_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing y");
      final List<RealVar> __y = y;
      Integer n;
      if (this.n != null && this.n.isPresent()) {
        n = this.n.get();
      } else {
        n = $generated__16(y);
      }
      final Integer __n = n;
      Matrix a;
      if (this.a != null && this.a.isPresent()) {
        a = this.a.get();
      } else {
        a = $generated__17(y, n);
      }
      final Matrix __a = a;
      List<IntVar> z;
      if (this.z != null && this.z.isPresent()) {
        z = this.z.get();
      } else {
        z = $generated__18(y, n, a);
      }
      final List<IntVar> __z = z;
      Integer K;
      if (this.K != null && this.K.isPresent()) {
        K = this.K.get();
      } else {
        K = $generated__19(y, n, a, z);
      }
      final Integer __K = K;
      Simplex pi;
      if (this.pi != null && this.pi.isPresent()) {
        pi = this.pi.get();
      } else {
        pi = $generated__20(y, n, a, z, K);
      }
      final Simplex __pi = pi;
      List<RealVar> mu;
      if (this.mu != null && this.mu.isPresent()) {
        mu = this.mu.get();
      } else {
        mu = $generated__21(y, n, a, z, K, pi);
      }
      final List<RealVar> __mu = mu;
      List<RealVar> sd;
      if (this.sd != null && this.sd.isPresent()) {
        sd = this.sd.get();
      } else {
        sd = $generated__22(y, n, a, z, K, pi, mu);
      }
      final List<RealVar> __sd = sd;
      // Build the instance after boxing params
      return new MixtureModel(
        __y, 
        __z, 
        __pi, 
        __mu, 
        __sd, 
        new ConstantSupplier(__n), 
        new ConstantSupplier(__a), 
        new ConstantSupplier(__K)
      );
    }
  }
  
  @DesignatedConstructor
  public static MixtureModel.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  private final List<RealVar> y;
  
  public List<RealVar> getY() {
    return y;
  }
  
  @Param
  private final Supplier<Integer> $generated__n;
  
  public Integer getN() {
    return $generated__n.get();
  }
  
  @Param
  private final Supplier<Matrix> $generated__a;
  
  public Matrix getA() {
    return $generated__a.get();
  }
  
  private final List<IntVar> z;
  
  public List<IntVar> getZ() {
    return z;
  }
  
  @Param
  private final Supplier<Integer> $generated__K;
  
  public Integer getK() {
    return $generated__K.get();
  }
  
  private final Simplex pi;
  
  public Simplex getPi() {
    return pi;
  }
  
  private final List<RealVar> mu;
  
  public List<RealVar> getMu() {
    return mu;
  }
  
  private final List<RealVar> sd;
  
  public List<RealVar> getSd() {
    return sd;
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * pi
   */
  private static Simplex $generated__0(final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z, final Integer K, final Simplex pi, final List<RealVar> mu, final List<RealVar> sd) {
    return pi;
  }
  
  /**
   * Auxiliary method generated to translate:
   * a
   */
  private static Matrix $generated__1(final Matrix a) {
    return a;
  }
  
  public static class $generated__1_class implements Supplier<Matrix> {
    public Matrix get() {
      return $generated__1($generated__a.get());
    }
    
    public String toString() {
      return "a";
    }
    
    private final Supplier<Matrix> $generated__a;
    
    public $generated__1_class(final Supplier<Matrix> $generated__a) {
      this.$generated__a = $generated__a;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 0 ..< K
   */
  private static Iterable<Integer> $generated__2(final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z, final Integer K, final Simplex pi, final List<RealVar> mu, final List<RealVar> sd) {
    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, (K).intValue(), true);
    return _doubleDotLessThan;
  }
  
  /**
   * Auxiliary method generated to translate:
   * mu. get (k)
   */
  private static RealVar $generated__3(final int k, final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z, final Integer K, final Simplex pi, final List<RealVar> mu, final List<RealVar> sd) {
    RealVar _get = mu.get(k);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 0.0
   */
  private static RealVar $generated__4() {
    return new blang.core.RealConstant(0.0);
  }
  
  public static class $generated__4_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__4();
    }
    
    public String toString() {
      return "0.0";
    }
    
    public $generated__4_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 100.0
   */
  private static RealVar $generated__5() {
    return new blang.core.RealConstant(100.0);
  }
  
  public static class $generated__5_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__5();
    }
    
    public String toString() {
      return "100.0";
    }
    
    public $generated__5_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * sd. get (k)
   */
  private static RealVar $generated__6(final int k, final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z, final Integer K, final Simplex pi, final List<RealVar> mu, final List<RealVar> sd) {
    RealVar _get = sd.get(k);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 0.0
   */
  private static RealVar $generated__7() {
    return new blang.core.RealConstant(0.0);
  }
  
  public static class $generated__7_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__7();
    }
    
    public String toString() {
      return "0.0";
    }
    
    public $generated__7_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 10.0
   */
  private static RealVar $generated__8() {
    return new blang.core.RealConstant(10.0);
  }
  
  public static class $generated__8_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__8();
    }
    
    public String toString() {
      return "10.0";
    }
    
    public $generated__8_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 0 ..< n
   */
  private static Iterable<Integer> $generated__9(final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z, final Integer K, final Simplex pi, final List<RealVar> mu, final List<RealVar> sd) {
    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, (n).intValue(), true);
    return _doubleDotLessThan;
  }
  
  /**
   * Auxiliary method generated to translate:
   * z.get(i)
   */
  private static IntVar $generated__10(final int i, final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z, final Integer K, final Simplex pi, final List<RealVar> mu, final List<RealVar> sd) {
    IntVar _get = z.get(i);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * pi
   */
  private static Simplex $generated__11(final Simplex pi) {
    return pi;
  }
  
  public static class $generated__11_class implements Supplier<Simplex> {
    public Simplex get() {
      return $generated__11(pi);
    }
    
    public String toString() {
      return "pi";
    }
    
    private final Simplex pi;
    
    public $generated__11_class(final Simplex pi) {
      this.pi = pi;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * z.get(i)
   */
  private static IntVar $generated__12(final int i, final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z, final Integer K, final Simplex pi, final List<RealVar> mu, final List<RealVar> sd) {
    IntVar _get = z.get(i);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * y.get(i)
   */
  private static RealVar $generated__13(final int i, final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z, final Integer K, final Simplex pi, final List<RealVar> mu, final List<RealVar> sd) {
    RealVar _get = y.get(i);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * mu.get(k)
   */
  private static RealVar $generated__14(final List<RealVar> mu, final List<RealVar> sd, final IntVar k) {
    RealVar _get = mu.get((k).intValue());
    return _get;
  }
  
  public static class $generated__14_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__14(mu, sd, k);
    }
    
    public String toString() {
      return "mu.get(k)";
    }
    
    private final List<RealVar> mu;
    
    private final List<RealVar> sd;
    
    private final IntVar k;
    
    public $generated__14_class(final List<RealVar> mu, final List<RealVar> sd, final IntVar k) {
      this.mu = mu;
      this.sd = sd;
      this.k = k;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * pow(sd.get(k), 2.0)
   */
  private static RealVar $generated__15(final List<RealVar> mu, final List<RealVar> sd, final IntVar k) {
    double _pow = Math.pow((sd.get((k).intValue())).doubleValue(), 2.0);
    return new blang.core.RealConstant(_pow);
  }
  
  public static class $generated__15_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__15(mu, sd, k);
    }
    
    public String toString() {
      return "pow(sd.get(k), 2.0)";
    }
    
    private final List<RealVar> mu;
    
    private final List<RealVar> sd;
    
    private final IntVar k;
    
    public $generated__15_class(final List<RealVar> mu, final List<RealVar> sd, final IntVar k) {
      this.mu = mu;
      this.sd = sd;
      this.k = k;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * y.size
   */
  private static Integer $generated__16(final List<RealVar> y) {
    int _size = y.size();
    return Integer.valueOf(_size);
  }
  
  /**
   * Auxiliary method generated to translate:
   * fixedVector (1.0 , 1.0)
   */
  private static Matrix $generated__17(final List<RealVar> y, final Integer n) {
    DenseMatrix _fixedVector = StaticUtils.fixedVector(1.0, 1.0);
    return _fixedVector;
  }
  
  /**
   * Auxiliary method generated to translate:
   * latentIntList(n)
   */
  private static List<IntVar> $generated__18(final List<RealVar> y, final Integer n, final Matrix a) {
    List<IntVar> _latentIntList = StaticUtils.latentIntList((n).intValue());
    return _latentIntList;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 2
   */
  private static Integer $generated__19(final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z) {
    return Integer.valueOf(2);
  }
  
  /**
   * Auxiliary method generated to translate:
   * latentSimplex(K)
   */
  private static Simplex $generated__20(final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z, final Integer K) {
    DenseSimplex _latentSimplex = StaticUtils.latentSimplex((K).intValue());
    return _latentSimplex;
  }
  
  /**
   * Auxiliary method generated to translate:
   * latentRealList(K)
   */
  private static List<RealVar> $generated__21(final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z, final Integer K, final Simplex pi) {
    List<RealVar> _latentRealList = StaticUtils.latentRealList((K).intValue());
    return _latentRealList;
  }
  
  /**
   * Auxiliary method generated to translate:
   * latentRealList(K)
   */
  private static List<RealVar> $generated__22(final List<RealVar> y, final Integer n, final Matrix a, final List<IntVar> z, final Integer K, final Simplex pi, final List<RealVar> mu) {
    List<RealVar> _latentRealList = StaticUtils.latentRealList((K).intValue());
    return _latentRealList;
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public MixtureModel(@DeboxedName("y") final List<RealVar> y, @DeboxedName("z") final List<IntVar> z, @DeboxedName("pi") final Simplex pi, @DeboxedName("mu") final List<RealVar> mu, @DeboxedName("sd") final List<RealVar> sd, @Param @DeboxedName("n") final Supplier<Integer> $generated__n, @Param @DeboxedName("a") final Supplier<Matrix> $generated__a, @Param @DeboxedName("K") final Supplier<Integer> $generated__K) {
    this.y = y;
    this.$generated__n = $generated__n;
    this.$generated__a = $generated__a;
    this.z = z;
    this.$generated__K = $generated__K;
    this.pi = pi;
    this.mu = mu;
    this.sd = sd;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    { // Code generated by: pi | a ~ Dirichlet (a)
      // Construction and addition of the factor/model:
      components.add(
        new blang.distributions.Dirichlet(
          $generated__0(y, $generated__n.get(), $generated__a.get(), z, $generated__K.get(), pi, mu, sd), 
          new $generated__1_class($generated__a)
        )
        );
    }
    for (int k : $generated__2(y, $generated__n.get(), $generated__a.get(), z, $generated__K.get(), pi, mu, sd)) {
      { // Code generated by: mu. get (k) ~ Normal(0.0, 100.0)
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.Normal(
            $generated__3(k, y, $generated__n.get(), $generated__a.get(), z, $generated__K.get(), pi, mu, sd), 
            new $generated__4_class(), 
            new $generated__5_class()
          )
          );
      }
      { // Code generated by: sd. get (k) ~ ContinuousUniform(0.0 ,10.0)
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.ContinuousUniform(
            $generated__6(k, y, $generated__n.get(), $generated__a.get(), z, $generated__K.get(), pi, mu, sd), 
            new $generated__7_class(), 
            new $generated__8_class()
          )
          );
      }
    }
    for (int i : $generated__9(y, $generated__n.get(), $generated__a.get(), z, $generated__K.get(), pi, mu, sd)) {
      { // Code generated by: z.get(i) | pi ~ Categorical(pi)
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.Categorical(
            $generated__10(i, y, $generated__n.get(), $generated__a.get(), z, $generated__K.get(), pi, mu, sd), 
            new $generated__11_class(pi)
          )
          );
      }
      { // Code generated by: y.get(i) | mu, sd, IntVar k = z.get(i) ~ Normal(mu.get(k) , pow(sd.get(k), 2.0))
        // Required initialization:
        IntVar k = $generated__12(i, y, $generated__n.get(), $generated__a.get(), z, $generated__K.get(), pi, mu, sd);
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.Normal(
            $generated__13(i, y, $generated__n.get(), $generated__a.get(), z, $generated__K.get(), pi, mu, sd), 
            new $generated__14_class(mu, sd, k), 
            new $generated__15_class(mu, sd, k)
          )
          );
      }
    }
    
    return components;
  }
}
