package jss.hier;

import blang.core.ConstantSupplier;
import blang.core.DeboxedName;
import blang.core.IntVar;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.Param;
import blang.core.RealVar;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import blang.io.GlobalDataSource;
import blang.types.Index;
import blang.types.Plate;
import blang.types.Plated;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;

@SuppressWarnings("all")
public class Rocket implements Model {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public GlobalDataSource data;
    
    private boolean data_initialized = false;
    
    public Rocket.Builder setData(final GlobalDataSource data) {
      data_initialized = true;
      this.data = data;
      return this;
    }
    
    @Arg
    public Plate<String> countries;
    
    private boolean countries_initialized = false;
    
    public Rocket.Builder setCountries(final Plate<String> countries) {
      countries_initialized = true;
      this.countries = countries;
      return this;
    }
    
    @Arg
    public Plate<String> rockets;
    
    private boolean rockets_initialized = false;
    
    public Rocket.Builder setRockets(final Plate<String> rockets) {
      rockets_initialized = true;
      this.rockets = rockets;
      return this;
    }
    
    @Arg
    public Plated<RealVar> alpha;
    
    private boolean alpha_initialized = false;
    
    public Rocket.Builder setAlpha(final Plated<RealVar> alpha) {
      alpha_initialized = true;
      this.alpha = alpha;
      return this;
    }
    
    @Arg
    public Plated<RealVar> beta;
    
    private boolean beta_initialized = false;
    
    public Rocket.Builder setBeta(final Plated<RealVar> beta) {
      beta_initialized = true;
      this.beta = beta;
      return this;
    }
    
    @Arg
    public Plated<RealVar> prob;
    
    private boolean prob_initialized = false;
    
    public Rocket.Builder setProb(final Plated<RealVar> prob) {
      prob_initialized = true;
      this.prob = prob;
      return this;
    }
    
    @Arg
    public Plated<IntVar> nFails;
    
    private boolean nFails_initialized = false;
    
    public Rocket.Builder setNFails(final Plated<IntVar> nFails) {
      nFails_initialized = true;
      this.nFails = nFails;
      return this;
    }
    
    @Arg
    public Plated<Integer> nLaunches;
    
    private boolean nLaunches_initialized = false;
    
    public Rocket.Builder setNLaunches(final Plated<Integer> nLaunches) {
      nLaunches_initialized = true;
      this.nLaunches = nLaunches;
      return this;
    }
    
    public Rocket build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      if (!fromCommandLine && !data_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing data");
      final GlobalDataSource __data = data;
      if (!fromCommandLine && !countries_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing countries");
      final Plate<String> __countries = countries;
      if (!fromCommandLine && !rockets_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing rockets");
      final Plate<String> __rockets = rockets;
      if (!fromCommandLine && !alpha_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing alpha");
      final Plated<RealVar> __alpha = alpha;
      if (!fromCommandLine && !beta_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing beta");
      final Plated<RealVar> __beta = beta;
      if (!fromCommandLine && !prob_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing prob");
      final Plated<RealVar> __prob = prob;
      if (!fromCommandLine && !nFails_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing nFails");
      final Plated<IntVar> __nFails = nFails;
      if (!fromCommandLine && !nLaunches_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing nLaunches");
      final Plated<Integer> __nLaunches = nLaunches;
      // Build the instance after boxing params
      return new Rocket(
        __alpha, 
        __beta, 
        __prob, 
        __nFails, 
        new ConstantSupplier(__data), 
        new ConstantSupplier(__countries), 
        new ConstantSupplier(__rockets), 
        new ConstantSupplier(__nLaunches)
      );
    }
  }
  
  @DesignatedConstructor
  public static Rocket.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  @Param
  private final Supplier<GlobalDataSource> $generated__data;
  
  public GlobalDataSource getData() {
    return $generated__data.get();
  }
  
  @Param
  private final Supplier<Plate<String>> $generated__countries;
  
  public Plate<String> getCountries() {
    return $generated__countries.get();
  }
  
  @Param
  private final Supplier<Plate<String>> $generated__rockets;
  
  public Plate<String> getRockets() {
    return $generated__rockets.get();
  }
  
  private final Plated<RealVar> alpha;
  
  public Plated<RealVar> getAlpha() {
    return alpha;
  }
  
  private final Plated<RealVar> beta;
  
  public Plated<RealVar> getBeta() {
    return beta;
  }
  
  private final Plated<RealVar> prob;
  
  public Plated<RealVar> getProb() {
    return prob;
  }
  
  private final Plated<IntVar> nFails;
  
  public Plated<IntVar> getNFails() {
    return nFails;
  }
  
  @Param
  private final Supplier<Plated<Integer>> $generated__nLaunches;
  
  public Plated<Integer> getNLaunches() {
    return $generated__nLaunches.get();
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * countries.indices()
   */
  private static Iterable<Index<String>> $generated__0(final GlobalDataSource data, final Plate<String> countries, final Plate<String> rockets, final Plated<RealVar> alpha, final Plated<RealVar> beta, final Plated<RealVar> prob, final Plated<IntVar> nFails, final Plated<Integer> nLaunches) {
    Collection<Index<String>> _indices = countries.indices();
    return _indices;
  }
  
  /**
   * Auxiliary method generated to translate:
   * alpha.get(c)
   */
  private static RealVar $generated__1(final Index<String> c, final GlobalDataSource data, final Plate<String> countries, final Plate<String> rockets, final Plated<RealVar> alpha, final Plated<RealVar> beta, final Plated<RealVar> prob, final Plated<IntVar> nFails, final Plated<Integer> nLaunches) {
    RealVar _get = alpha.get(c);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 1
   */
  private static RealVar $generated__2() {
    return new blang.core.RealConstant(1);
  }
  
  public static class $generated__2_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__2();
    }
    
    public String toString() {
      return "1";
    }
    
    public $generated__2_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 1
   */
  private static RealVar $generated__3() {
    return new blang.core.RealConstant(1);
  }
  
  public static class $generated__3_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__3();
    }
    
    public String toString() {
      return "1";
    }
    
    public $generated__3_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * beta.get(c)
   */
  private static RealVar $generated__4(final Index<String> c, final GlobalDataSource data, final Plate<String> countries, final Plate<String> rockets, final Plated<RealVar> alpha, final Plated<RealVar> beta, final Plated<RealVar> prob, final Plated<IntVar> nFails, final Plated<Integer> nLaunches) {
    RealVar _get = beta.get(c);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 1
   */
  private static RealVar $generated__5() {
    return new blang.core.RealConstant(1);
  }
  
  public static class $generated__5_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__5();
    }
    
    public String toString() {
      return "1";
    }
    
    public $generated__5_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 1
   */
  private static RealVar $generated__6() {
    return new blang.core.RealConstant(1);
  }
  
  public static class $generated__6_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__6();
    }
    
    public String toString() {
      return "1";
    }
    
    public $generated__6_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * rockets.indices(c)
   */
  private static Iterable<Index<String>> $generated__7(final Index<String> c, final GlobalDataSource data, final Plate<String> countries, final Plate<String> rockets, final Plated<RealVar> alpha, final Plated<RealVar> beta, final Plated<RealVar> prob, final Plated<IntVar> nFails, final Plated<Integer> nLaunches) {
    Collection<Index<String>> _indices = rockets.indices(c);
    return _indices;
  }
  
  /**
   * Auxiliary method generated to translate:
   * alpha.get(c)
   */
  private static RealVar $generated__8(final Index<String> r, final Index<String> c, final GlobalDataSource data, final Plate<String> countries, final Plate<String> rockets, final Plated<RealVar> alpha, final Plated<RealVar> beta, final Plated<RealVar> prob, final Plated<IntVar> nFails, final Plated<Integer> nLaunches) {
    RealVar _get = alpha.get(c);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * beta.get(c)
   */
  private static RealVar $generated__9(final Index<String> r, final Index<String> c, final GlobalDataSource data, final Plate<String> countries, final Plate<String> rockets, final Plated<RealVar> alpha, final Plated<RealVar> beta, final Plated<RealVar> prob, final Plated<IntVar> nFails, final Plated<Integer> nLaunches) {
    RealVar _get = beta.get(c);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * prob.get(r, c)
   */
  private static RealVar $generated__10(final Index<String> r, final Index<String> c, final GlobalDataSource data, final Plate<String> countries, final Plate<String> rockets, final Plated<RealVar> alpha, final Plated<RealVar> beta, final Plated<RealVar> prob, final Plated<IntVar> nFails, final Plated<Integer> nLaunches) {
    RealVar _get = prob.get(r, c);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * a
   */
  private static RealVar $generated__11(final RealVar a, final RealVar b) {
    return a;
  }
  
  public static class $generated__11_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__11(a, b);
    }
    
    public String toString() {
      return "a";
    }
    
    private final RealVar a;
    
    private final RealVar b;
    
    public $generated__11_class(final RealVar a, final RealVar b) {
      this.a = a;
      this.b = b;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * b
   */
  private static RealVar $generated__12(final RealVar a, final RealVar b) {
    return b;
  }
  
  public static class $generated__12_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__12(a, b);
    }
    
    public String toString() {
      return "b";
    }
    
    private final RealVar a;
    
    private final RealVar b;
    
    public $generated__12_class(final RealVar a, final RealVar b) {
      this.a = a;
      this.b = b;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * prob.get(r, c)
   */
  private static RealVar $generated__13(final Index<String> r, final Index<String> c, final GlobalDataSource data, final Plate<String> countries, final Plate<String> rockets, final Plated<RealVar> alpha, final Plated<RealVar> beta, final Plated<RealVar> prob, final Plated<IntVar> nFails, final Plated<Integer> nLaunches) {
    RealVar _get = prob.get(r, c);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * nLaunches.get(r, c)
   */
  private static Integer $generated__14(final Index<String> r, final Index<String> c, final GlobalDataSource data, final Plate<String> countries, final Plate<String> rockets, final Plated<RealVar> alpha, final Plated<RealVar> beta, final Plated<RealVar> prob, final Plated<IntVar> nFails, final Plated<Integer> nLaunches) {
    Integer _get = nLaunches.get(r, c);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * nFails.get(c, r)
   */
  private static IntVar $generated__15(final Index<String> r, final Index<String> c, final GlobalDataSource data, final Plate<String> countries, final Plate<String> rockets, final Plated<RealVar> alpha, final Plated<RealVar> beta, final Plated<RealVar> prob, final Plated<IntVar> nFails, final Plated<Integer> nLaunches) {
    IntVar _get = nFails.get(c, r);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * n
   */
  private static IntVar $generated__16(final RealVar p, final Integer n) {
    return new blang.core.IntConstant(n);
  }
  
  public static class $generated__16_class implements Supplier<IntVar> {
    public IntVar get() {
      return $generated__16(p, n);
    }
    
    public String toString() {
      return "n";
    }
    
    private final RealVar p;
    
    private final Integer n;
    
    public $generated__16_class(final RealVar p, final Integer n) {
      this.p = p;
      this.n = n;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * p
   */
  private static RealVar $generated__17(final RealVar p, final Integer n) {
    return p;
  }
  
  public static class $generated__17_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__17(p, n);
    }
    
    public String toString() {
      return "p";
    }
    
    private final RealVar p;
    
    private final Integer n;
    
    public $generated__17_class(final RealVar p, final Integer n) {
      this.p = p;
      this.n = n;
    }
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public Rocket(@DeboxedName("alpha") final Plated<RealVar> alpha, @DeboxedName("beta") final Plated<RealVar> beta, @DeboxedName("prob") final Plated<RealVar> prob, @DeboxedName("nFails") final Plated<IntVar> nFails, @Param @DeboxedName("data") final Supplier<GlobalDataSource> $generated__data, @Param @DeboxedName("countries") final Supplier<Plate<String>> $generated__countries, @Param @DeboxedName("rockets") final Supplier<Plate<String>> $generated__rockets, @Param @DeboxedName("nLaunches") final Supplier<Plated<Integer>> $generated__nLaunches) {
    this.$generated__data = $generated__data;
    this.$generated__countries = $generated__countries;
    this.$generated__rockets = $generated__rockets;
    this.alpha = alpha;
    this.beta = beta;
    this.prob = prob;
    this.nFails = nFails;
    this.$generated__nLaunches = $generated__nLaunches;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    for (Index<String> c : $generated__0($generated__data.get(), $generated__countries.get(), $generated__rockets.get(), alpha, beta, prob, nFails, $generated__nLaunches.get())) {
      { // Code generated by: alpha.get(c) ~ Gamma(1,1)
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.Gamma(
            $generated__1(c, $generated__data.get(), $generated__countries.get(), $generated__rockets.get(), alpha, beta, prob, nFails, $generated__nLaunches.get()), 
            new $generated__2_class(), 
            new $generated__3_class()
          )
          );
      }
      { // Code generated by: beta.get(c) ~ Gamma(1,1)
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.Gamma(
            $generated__4(c, $generated__data.get(), $generated__countries.get(), $generated__rockets.get(), alpha, beta, prob, nFails, $generated__nLaunches.get()), 
            new $generated__5_class(), 
            new $generated__6_class()
          )
          );
      }
      for (Index<String> r : $generated__7(c, $generated__data.get(), $generated__countries.get(), $generated__rockets.get(), alpha, beta, prob, nFails, $generated__nLaunches.get())) {
        { // Code generated by: prob.get(r, c) | RealVar a = alpha.get(c), RealVar b = beta.get(c) ~ Beta(a, b)
          // Required initialization:
          RealVar a = $generated__8(r, c, $generated__data.get(), $generated__countries.get(), $generated__rockets.get(), alpha, beta, prob, nFails, $generated__nLaunches.get());
          RealVar b = $generated__9(r, c, $generated__data.get(), $generated__countries.get(), $generated__rockets.get(), alpha, beta, prob, nFails, $generated__nLaunches.get());
          // Construction and addition of the factor/model:
          components.add(
            new blang.distributions.Beta(
              $generated__10(r, c, $generated__data.get(), $generated__countries.get(), $generated__rockets.get(), alpha, beta, prob, nFails, $generated__nLaunches.get()), 
              new $generated__11_class(a, b), 
              new $generated__12_class(a, b)
            )
            );
        }
        { // Code generated by: nFails.get(c, r) | RealVar p = prob.get(r, c), Integer n = nLaunches.get(r, c) ~ Binomial(n, p)
          // Required initialization:
          RealVar p = $generated__13(r, c, $generated__data.get(), $generated__countries.get(), $generated__rockets.get(), alpha, beta, prob, nFails, $generated__nLaunches.get());
          Integer n = $generated__14(r, c, $generated__data.get(), $generated__countries.get(), $generated__rockets.get(), alpha, beta, prob, nFails, $generated__nLaunches.get());
          // Construction and addition of the factor/model:
          components.add(
            new blang.distributions.Binomial(
              $generated__15(r, c, $generated__data.get(), $generated__countries.get(), $generated__rockets.get(), alpha, beta, prob, nFails, $generated__nLaunches.get()), 
              new $generated__16_class(p, n), 
              new $generated__17_class(p, n)
            )
            );
        }
      }
    }
    
    return components;
  }
}
