package jss.others;

import blang.core.ConstantSupplier;
import blang.core.DeboxedName;
import blang.core.Distribution;
import blang.core.DistributionAdaptor;
import blang.core.ForwardSimulator;
import blang.core.IntDistribution;
import blang.core.IntDistributionAdaptor;
import blang.core.IntVar;
import blang.core.LogScaleFactor;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.Param;
import blang.core.UnivariateModel;
import blang.core.WritableIntVar;
import blang.distributions.Generators;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import blang.types.Simplex;
import blang.types.StaticUtils;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import xlinear.MatrixExtensions;

@SuppressWarnings("all")
public class IntMixtureExample implements Model, UnivariateModel<IntVar>, ForwardSimulator {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public Simplex proportions;
    
    private boolean proportions_initialized = false;
    
    public IntMixtureExample.Builder setProportions(final Simplex proportions) {
      proportions_initialized = true;
      this.proportions = proportions;
      return this;
    }
    
    @Arg
    public List<IntDistribution> components;
    
    private boolean components_initialized = false;
    
    public IntMixtureExample.Builder setComponents(final List<IntDistribution> components) {
      components_initialized = true;
      this.components = components;
      return this;
    }
    
    @Arg
    public IntVar realization;
    
    private boolean realization_initialized = false;
    
    public IntMixtureExample.Builder setRealization(final IntVar realization) {
      realization_initialized = true;
      this.realization = realization;
      return this;
    }
    
    public IntMixtureExample build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      if (!fromCommandLine && !proportions_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing proportions");
      final Simplex __proportions = proportions;
      if (!fromCommandLine && !components_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing components");
      final List<IntDistribution> __components = components;
      if (!fromCommandLine && !realization_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing realization");
      final IntVar __realization = realization;
      // Build the instance after boxing params
      return new IntMixtureExample(
        __realization, 
        new ConstantSupplier(__proportions), 
        new ConstantSupplier(__components)
      );
    }
  }
  
  @DesignatedConstructor
  public static IntMixtureExample.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  @Param
  private final Supplier<Simplex> $generated__proportions;
  
  public Simplex getProportions() {
    return $generated__proportions.get();
  }
  
  @Param
  private final Supplier<List<IntDistribution>> $generated__components;
  
  public List<IntDistribution> getComponents() {
    return $generated__components.get();
  }
  
  private final IntVar realization;
  
  public IntVar getRealization() {
    return realization;
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * { var sum = 0.0 if (components.size !== proportions.nEntries) throw new RuntimeException for (i : 0 ..< components.size) { val prop = proportions.get(i) if (prop < 0.0 || prop > 1.0) return NEGATIVE_INFINITY sum += prop * exp(components.get(i).logDensity(realization)) } return log(sum) }
   */
  private static double $generated__0(final Simplex proportions, final List<IntDistribution> components, final IntVar realization) {
    double sum = 0.0;
    int _size = components.size();
    int _nEntries = proportions.nEntries();
    boolean _tripleNotEquals = (_size != _nEntries);
    if (_tripleNotEquals) {
      throw new RuntimeException();
    }
    int _size_1 = components.size();
    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_1, true);
    for (final Integer i : _doubleDotLessThan) {
      {
        final double prop = proportions.get((i).intValue());
        if (((prop < 0.0) || (prop > 1.0))) {
          return StaticUtils.NEGATIVE_INFINITY();
        }
        double _sum = sum;
        double _exp = Math.exp(components.get((i).intValue()).logDensity((realization).intValue()));
        double _multiply = (prop * _exp);
        sum = (_sum + _multiply);
      }
    }
    return Math.log(sum);
  }
  
  public static class $generated__0_class implements LogScaleFactor {
    public double logDensity() {
      return $generated__0($generated__proportions.get(), $generated__components.get(), realization);
    }
    
    public String toString() {
      return "{ var sum = 0.0 if (components.size !== proportions.nEntries) throw new RuntimeException for (i : 0 ..< components.size) { val prop = proportions.get(i) if (prop < 0.0 || prop > 1.0) return NEGATIVE_INFINITY sum += prop * exp(components.get(i).logDensity(realization)) } return log(sum) }";
    }
    
    private final Supplier<Simplex> $generated__proportions;
    
    private final Supplier<List<IntDistribution>> $generated__components;
    
    private final IntVar realization;
    
    public $generated__0_class(final Supplier<Simplex> $generated__proportions, final Supplier<List<IntDistribution>> $generated__components, final IntVar realization) {
      this.$generated__proportions = $generated__proportions;
      this.$generated__components = $generated__components;
      this.realization = realization;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * { val category = rand.categorical(proportions.vectorToArray) return components.get(category).sample(rand) }
   */
  private static Integer $generated__1(final Random rand, final Simplex proportions, final List<IntDistribution> components, final IntVar realization) {
    final int category = Generators.categorical(rand, MatrixExtensions.vectorToArray(proportions));
    return Integer.valueOf(components.get(category).sample(rand));
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public IntMixtureExample(@DeboxedName("realization") final IntVar realization, @Param @DeboxedName("proportions") final Supplier<Simplex> $generated__proportions, @Param @DeboxedName("components") final Supplier<List<IntDistribution>> $generated__components) {
    this.$generated__proportions = $generated__proportions;
    this.$generated__components = $generated__components;
    this.realization = realization;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    { // Code generated by: (proportions, components, realization) { var sum = 0.0 if (components.size !== proportions.nEntries) throw new RuntimeException for (i : 0 ..< components.size) { val prop = proportions.get(i) if (prop < 0.0 || prop > 1.0) return NEGATIVE_INFINITY sum += prop * exp(components.get(i).logDensity(realization)) } return log(sum) }
      // Construction and addition of the factor/model:
      components.add(
        new $generated__0_class($generated__proportions, $generated__components, realization));
    }
    
    return components;
  }
  
  public void generate(final Random rand) {
    ((WritableIntVar) realization).set(
      $generated__1(rand, $generated__proportions.get(), $generated__components.get(), realization)
    );
  }
  
  public IntVar realization() {
    return realization;
  }
  
  /**
   * Returns an instance with fixed parameters values and conforming the Distribution interface. 
   * Useful when passing around distributions as parameters, e.g. for Dirichlet Process mixtures. 
   * 
   */
  public static IntDistribution distribution(@Param final Simplex proportions, @Param final List<IntDistribution> components) {
    UnivariateModel<IntVar> univariateModel = new IntMixtureExample(
      new IntDistributionAdaptor.WritableIntVarImpl(), 
      new ConstantSupplier(proportions), 
      new ConstantSupplier(components)
    );
    Distribution<IntVar> distribution = new DistributionAdaptor(univariateModel);
    return new IntDistributionAdaptor(distribution);
  }
}
