package jss.others;

import blang.core.ConstantSupplier;
import blang.core.DeboxedName;
import blang.core.ForwardSimulator;
import blang.core.LogScaleFactor;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.Param;
import blang.core.RealVar;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Supplier;

@SuppressWarnings("all")
public class LogPotentialExample implements Model, ForwardSimulator {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public RealVar logPotential;
    
    private boolean logPotential_initialized = false;
    
    public LogPotentialExample.Builder setLogPotential(final RealVar logPotential) {
      logPotential_initialized = true;
      this.logPotential = logPotential;
      return this;
    }
    
    public LogPotentialExample build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      if (!fromCommandLine && !logPotential_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing logPotential");
      final RealVar __logPotential = logPotential;
      // Build the instance after boxing params
      return new LogPotentialExample(
        new ConstantSupplier(__logPotential)
      );
    }
  }
  
  @DesignatedConstructor
  public static LogPotentialExample.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  @Param
  private final Supplier<RealVar> $generated__logPotential;
  
  public RealVar getLogPotential() {
    return $generated__logPotential.get();
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * { return logPotential }
   */
  private static double $generated__0(final RealVar logPotential) {
    return (logPotential).doubleValue();
  }
  
  public static class $generated__0_class implements LogScaleFactor {
    public double logDensity() {
      return $generated__0($generated__logPotential.get());
    }
    
    public String toString() {
      return "{ return logPotential }";
    }
    
    private final Supplier<RealVar> $generated__logPotential;
    
    public $generated__0_class(final Supplier<RealVar> $generated__logPotential) {
      this.$generated__logPotential = $generated__logPotential;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * { throw new RuntimeException }
   */
  private static void $generated__1(final Random rand, final RealVar logPotential) {
    throw new RuntimeException();
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public LogPotentialExample(@Param @DeboxedName("logPotential") final Supplier<RealVar> $generated__logPotential) {
    this.$generated__logPotential = $generated__logPotential;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    { // Code generated by: (logPotential) { return logPotential }
      // Construction and addition of the factor/model:
      components.add(
        new $generated__0_class($generated__logPotential));
    }
    
    return components;
  }
  
  public void generate(final Random rand) {
    $generated__1(rand, $generated__logPotential.get());
  }
}
