package jss.others;

import blang.core.ConstantSupplier;
import blang.core.DeboxedName;
import blang.core.Distribution;
import blang.core.DistributionAdaptor;
import blang.core.IntVar;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.Param;
import blang.core.UnivariateModel;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import blang.types.DenseSimplex;
import blang.types.DenseTransitionMatrix;
import blang.types.Simplex;
import blang.types.StaticUtils;
import blang.types.TransitionMatrix;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

@SuppressWarnings("all")
public class MarkovChainExample implements Model, UnivariateModel<List<IntVar>> {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public Optional<Simplex> initialDistribution;
    
    public MarkovChainExample.Builder setInitialDistribution(final Simplex initialDistribution) {
      // work around typeRef(..) limitation
      Optional<Simplex> $generated__dummy = null;
      this.initialDistribution = Optional.of(initialDistribution);
      return this;
    }
    
    @Arg
    public Optional<TransitionMatrix> transitionProbabilities;
    
    public MarkovChainExample.Builder setTransitionProbabilities(final TransitionMatrix transitionProbabilities) {
      // work around typeRef(..) limitation
      Optional<TransitionMatrix> $generated__dummy = null;
      this.transitionProbabilities = Optional.of(transitionProbabilities);
      return this;
    }
    
    @Arg
    public List<IntVar> chain;
    
    private boolean chain_initialized = false;
    
    public MarkovChainExample.Builder setChain(final List<IntVar> chain) {
      chain_initialized = true;
      this.chain = chain;
      return this;
    }
    
    public MarkovChainExample build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      Simplex initialDistribution;
      if (this.initialDistribution != null && this.initialDistribution.isPresent()) {
        initialDistribution = this.initialDistribution.get();
      } else {
        initialDistribution = $generated__6();
      }
      final Simplex __initialDistribution = initialDistribution;
      TransitionMatrix transitionProbabilities;
      if (this.transitionProbabilities != null && this.transitionProbabilities.isPresent()) {
        transitionProbabilities = this.transitionProbabilities.get();
      } else {
        transitionProbabilities = $generated__7(initialDistribution);
      }
      final TransitionMatrix __transitionProbabilities = transitionProbabilities;
      if (!fromCommandLine && !chain_initialized)
        throw new RuntimeException("Not all fields were set in the builder, e.g. missing chain");
      final List<IntVar> __chain = chain;
      // Build the instance after boxing params
      return new MarkovChainExample(
        __chain, 
        new ConstantSupplier(__initialDistribution), 
        new ConstantSupplier(__transitionProbabilities)
      );
    }
  }
  
  @DesignatedConstructor
  public static MarkovChainExample.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  @Param
  private final Supplier<Simplex> $generated__initialDistribution;
  
  public Simplex getInitialDistribution() {
    return $generated__initialDistribution.get();
  }
  
  @Param
  private final Supplier<TransitionMatrix> $generated__transitionProbabilities;
  
  public TransitionMatrix getTransitionProbabilities() {
    return $generated__transitionProbabilities.get();
  }
  
  private final List<IntVar> chain;
  
  public List<IntVar> getChain() {
    return chain;
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * chain.get(0)
   */
  private static IntVar $generated__0(final Simplex initialDistribution, final TransitionMatrix transitionProbabilities, final List<IntVar> chain) {
    IntVar _get = chain.get(0);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * initialDistribution
   */
  private static Simplex $generated__1(final Simplex initialDistribution) {
    return initialDistribution;
  }
  
  public static class $generated__1_class implements Supplier<Simplex> {
    public Simplex get() {
      return $generated__1($generated__initialDistribution.get());
    }
    
    public String toString() {
      return "initialDistribution";
    }
    
    private final Supplier<Simplex> $generated__initialDistribution;
    
    public $generated__1_class(final Supplier<Simplex> $generated__initialDistribution) {
      this.$generated__initialDistribution = $generated__initialDistribution;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 1 ..< chain.size
   */
  private static Iterable<Integer> $generated__2(final Simplex initialDistribution, final TransitionMatrix transitionProbabilities, final List<IntVar> chain) {
    int _size = chain.size();
    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(1, _size, true);
    return _doubleDotLessThan;
  }
  
  /**
   * Auxiliary method generated to translate:
   * chain.get(step - 1)
   */
  private static IntVar $generated__3(final int step, final Simplex initialDistribution, final TransitionMatrix transitionProbabilities, final List<IntVar> chain) {
    IntVar _get = chain.get((step - 1));
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * chain.get(step)
   */
  private static IntVar $generated__4(final int step, final Simplex initialDistribution, final TransitionMatrix transitionProbabilities, final List<IntVar> chain) {
    IntVar _get = chain.get(step);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * if (previous >= 0 && previous < transitionProbabilities.nRows) transitionProbabilities.row(previous) else transitionProbabilities.row(0)
   */
  private static Simplex $generated__5(final IntVar previous, final TransitionMatrix transitionProbabilities) {
    Simplex _xifexpression = null;
    if ((((previous).intValue() >= 0) && ((previous).intValue() < transitionProbabilities.nRows()))) {
      _xifexpression = transitionProbabilities.row((previous).intValue());
    } else {
      _xifexpression = transitionProbabilities.row(0);
    }
    return _xifexpression;
  }
  
  public static class $generated__5_class implements Supplier<Simplex> {
    public Simplex get() {
      return $generated__5(previous, $generated__transitionProbabilities.get());
    }
    
    public String toString() {
      return "if (previous >= 0 && previous < transitionProbabilities.nRows) transitionProbabilities.row(previous) else transitionProbabilities.row(0)";
    }
    
    private final IntVar previous;
    
    private final Supplier<TransitionMatrix> $generated__transitionProbabilities;
    
    public $generated__5_class(final IntVar previous, final Supplier<TransitionMatrix> $generated__transitionProbabilities) {
      this.previous = previous;
      this.$generated__transitionProbabilities = $generated__transitionProbabilities;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * fixedSimplex(0.5, 0.5)
   */
  private static Simplex $generated__6() {
    DenseSimplex _fixedSimplex = StaticUtils.fixedSimplex(0.5, 0.5);
    return _fixedSimplex;
  }
  
  /**
   * Auxiliary method generated to translate:
   * fixedTransitionMatrix(#[#[0.1, 0.9], #[0.9, 0.1]])
   */
  private static TransitionMatrix $generated__7(final Simplex initialDistribution) {
    DenseTransitionMatrix _fixedTransitionMatrix = StaticUtils.fixedTransitionMatrix(new double[][] { new double[] { 0.1, 0.9 }, new double[] { 0.9, 0.1 } });
    return _fixedTransitionMatrix;
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public MarkovChainExample(@DeboxedName("chain") final List<IntVar> chain, @Param @DeboxedName("initialDistribution") final Supplier<Simplex> $generated__initialDistribution, @Param @DeboxedName("transitionProbabilities") final Supplier<TransitionMatrix> $generated__transitionProbabilities) {
    this.$generated__initialDistribution = $generated__initialDistribution;
    this.$generated__transitionProbabilities = $generated__transitionProbabilities;
    this.chain = chain;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    { // Code generated by: chain.get(0) | initialDistribution ~ Categorical(initialDistribution)
      // Construction and addition of the factor/model:
      components.add(
        new blang.distributions.Categorical(
          $generated__0($generated__initialDistribution.get(), $generated__transitionProbabilities.get(), chain), 
          new $generated__1_class($generated__initialDistribution)
        )
        );
    }
    for (int step : $generated__2($generated__initialDistribution.get(), $generated__transitionProbabilities.get(), chain)) {
      { // Code generated by: chain.get(step) | IntVar previous = chain.get(step - 1), transitionProbabilities ~ Categorical( if (previous >= 0 && previous < transitionProbabilities.nRows) transitionProbabilities.row(previous) else transitionProbabilities.row(0) )
        // Required initialization:
        IntVar previous = $generated__3(step, $generated__initialDistribution.get(), $generated__transitionProbabilities.get(), chain);
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.Categorical(
            $generated__4(step, $generated__initialDistribution.get(), $generated__transitionProbabilities.get(), chain), 
            new $generated__5_class(previous, $generated__transitionProbabilities)
          )
          );
      }
    }
    
    return components;
  }
  
  public List<IntVar> realization() {
    return chain;
  }
  
  /**
   * Returns an instance with fixed parameters values and conforming the Distribution interface. 
   * Useful when passing around distributions as parameters, e.g. for Dirichlet Process mixtures. 
   * 
   */
  public static Distribution<List<IntVar>> distribution(final List<IntVar> chain, @Param final Simplex initialDistribution, @Param final TransitionMatrix transitionProbabilities) {
    UnivariateModel<List<IntVar>> univariateModel = new MarkovChainExample(
      chain, 
      new ConstantSupplier(initialDistribution), 
      new ConstantSupplier(transitionProbabilities)
    );
    Distribution<List<IntVar>> distribution = new DistributionAdaptor(univariateModel);
    return distribution;
  }
}
