package jss.others;

import blang.core.DeboxedName;
import blang.core.IntDistribution;
import blang.core.IntVar;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.RealVar;
import blang.distributions.Poisson;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import blang.types.DenseSimplex;
import blang.types.Simplex;
import blang.types.StaticUtils;
import blang.types.internals.RealScalar;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

@SuppressWarnings("all")
public class PoissonPoissonMixtureExample implements Model {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public Optional<List<IntVar>> observations;
    
    public PoissonPoissonMixtureExample.Builder setObservations(final List<IntVar> observations) {
      // work around typeRef(..) limitation
      Optional<List<IntVar>> $generated__dummy = null;
      this.observations = Optional.of(observations);
      return this;
    }
    
    @Arg
    public Optional<RealVar> lambda1;
    
    public PoissonPoissonMixtureExample.Builder setLambda1(final RealVar lambda1) {
      // work around typeRef(..) limitation
      Optional<RealVar> $generated__dummy = null;
      this.lambda1 = Optional.of(lambda1);
      return this;
    }
    
    @Arg
    public Optional<RealVar> lambda2;
    
    public PoissonPoissonMixtureExample.Builder setLambda2(final RealVar lambda2) {
      // work around typeRef(..) limitation
      Optional<RealVar> $generated__dummy = null;
      this.lambda2 = Optional.of(lambda2);
      return this;
    }
    
    @Arg
    public Optional<Simplex> pi;
    
    public PoissonPoissonMixtureExample.Builder setPi(final Simplex pi) {
      // work around typeRef(..) limitation
      Optional<Simplex> $generated__dummy = null;
      this.pi = Optional.of(pi);
      return this;
    }
    
    public PoissonPoissonMixtureExample build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      List<IntVar> observations;
      if (this.observations != null && this.observations.isPresent()) {
        observations = this.observations.get();
      } else {
        observations = $generated__11();
      }
      final List<IntVar> __observations = observations;
      RealVar lambda1;
      if (this.lambda1 != null && this.lambda1.isPresent()) {
        lambda1 = this.lambda1.get();
      } else {
        lambda1 = $generated__12(observations);
      }
      final RealVar __lambda1 = lambda1;
      RealVar lambda2;
      if (this.lambda2 != null && this.lambda2.isPresent()) {
        lambda2 = this.lambda2.get();
      } else {
        lambda2 = $generated__13(observations, lambda1);
      }
      final RealVar __lambda2 = lambda2;
      Simplex pi;
      if (this.pi != null && this.pi.isPresent()) {
        pi = this.pi.get();
      } else {
        pi = $generated__14(observations, lambda1, lambda2);
      }
      final Simplex __pi = pi;
      // Build the instance after boxing params
      return new PoissonPoissonMixtureExample(
        __observations, 
        __lambda1, 
        __lambda2, 
        __pi
      );
    }
  }
  
  @DesignatedConstructor
  public static PoissonPoissonMixtureExample.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  private final List<IntVar> observations;
  
  public List<IntVar> getObservations() {
    return observations;
  }
  
  private final RealVar lambda1;
  
  public RealVar getLambda1() {
    return lambda1;
  }
  
  private final RealVar lambda2;
  
  public RealVar getLambda2() {
    return lambda2;
  }
  
  private final Simplex pi;
  
  public Simplex getPi() {
    return pi;
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * pi
   */
  private static Simplex $generated__0(final List<IntVar> observations, final RealVar lambda1, final RealVar lambda2, final Simplex pi) {
    return pi;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 2
   */
  private static Integer $generated__1() {
    return Integer.valueOf(2);
  }
  
  public static class $generated__1_class implements Supplier<Integer> {
    public Integer get() {
      return $generated__1();
    }
    
    public String toString() {
      return "2";
    }
    
    public $generated__1_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 1
   */
  private static RealVar $generated__2() {
    return new blang.core.RealConstant(1);
  }
  
  public static class $generated__2_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__2();
    }
    
    public String toString() {
      return "1";
    }
    
    public $generated__2_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * lambda1
   */
  private static RealVar $generated__3(final List<IntVar> observations, final RealVar lambda1, final RealVar lambda2, final Simplex pi) {
    return lambda1;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 1.0/2.0
   */
  private static RealVar $generated__4() {
    return new blang.core.RealConstant((1.0 / 2.0));
  }
  
  public static class $generated__4_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__4();
    }
    
    public String toString() {
      return "1.0/2.0";
    }
    
    public $generated__4_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * lambda2
   */
  private static RealVar $generated__5(final List<IntVar> observations, final RealVar lambda1, final RealVar lambda2, final Simplex pi) {
    return lambda2;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 1.0/9.0
   */
  private static RealVar $generated__6() {
    return new blang.core.RealConstant((1.0 / 9.0));
  }
  
  public static class $generated__6_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__6();
    }
    
    public String toString() {
      return "1.0/9.0";
    }
    
    public $generated__6_class() {
      
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 0 ..< observations.size
   */
  private static Iterable<Integer> $generated__7(final List<IntVar> observations, final RealVar lambda1, final RealVar lambda2, final Simplex pi) {
    int _size = observations.size();
    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
    return _doubleDotLessThan;
  }
  
  /**
   * Auxiliary method generated to translate:
   * observations.get(i)
   */
  private static IntVar $generated__8(final int i, final List<IntVar> observations, final RealVar lambda1, final RealVar lambda2, final Simplex pi) {
    IntVar _get = observations.get(i);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * pi
   */
  private static Simplex $generated__9(final Simplex pi, final RealVar lambda1, final RealVar lambda2) {
    return pi;
  }
  
  public static class $generated__9_class implements Supplier<Simplex> {
    public Simplex get() {
      return $generated__9(pi, lambda1, lambda2);
    }
    
    public String toString() {
      return "pi";
    }
    
    private final Simplex pi;
    
    private final RealVar lambda1;
    
    private final RealVar lambda2;
    
    public $generated__9_class(final Simplex pi, final RealVar lambda1, final RealVar lambda2) {
      this.pi = pi;
      this.lambda1 = lambda1;
      this.lambda2 = lambda2;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * #[ Poisson::distribution(lambda1), Poisson::distribution(lambda2) ]
   */
  private static List<IntDistribution> $generated__10(final Simplex pi, final RealVar lambda1, final RealVar lambda2) {
    IntDistribution _distribution = Poisson.distribution(lambda1);
    IntDistribution _distribution_1 = Poisson.distribution(lambda2);
    return Collections.<IntDistribution>unmodifiableList(CollectionLiterals.<IntDistribution>newArrayList(_distribution, _distribution_1));
  }
  
  public static class $generated__10_class implements Supplier<List<IntDistribution>> {
    public List<IntDistribution> get() {
      return $generated__10(pi, lambda1, lambda2);
    }
    
    public String toString() {
      return "#[ Poisson::distribution(lambda1), Poisson::distribution(lambda2) ]";
    }
    
    private final Simplex pi;
    
    private final RealVar lambda1;
    
    private final RealVar lambda2;
    
    public $generated__10_class(final Simplex pi, final RealVar lambda1, final RealVar lambda2) {
      this.pi = pi;
      this.lambda1 = lambda1;
      this.lambda2 = lambda2;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * #[1, 3, 2, 8, 9, 10]
   */
  private static List<IntVar> $generated__11() {
    return Collections.<IntVar>unmodifiableList(CollectionLiterals.<IntVar>newArrayList(new blang.core.IntConstant(1), new blang.core.IntConstant(3), new blang.core.IntConstant(2), new blang.core.IntConstant(8), new blang.core.IntConstant(9), new blang.core.IntConstant(10)));
  }
  
  /**
   * Auxiliary method generated to translate:
   * latentReal
   */
  private static RealVar $generated__12(final List<IntVar> observations) {
    RealScalar _latentReal = StaticUtils.latentReal();
    return _latentReal;
  }
  
  /**
   * Auxiliary method generated to translate:
   * latentReal
   */
  private static RealVar $generated__13(final List<IntVar> observations, final RealVar lambda1) {
    RealScalar _latentReal = StaticUtils.latentReal();
    return _latentReal;
  }
  
  /**
   * Auxiliary method generated to translate:
   * latentSimplex(2)
   */
  private static Simplex $generated__14(final List<IntVar> observations, final RealVar lambda1, final RealVar lambda2) {
    DenseSimplex _latentSimplex = StaticUtils.latentSimplex(2);
    return _latentSimplex;
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public PoissonPoissonMixtureExample(@DeboxedName("observations") final List<IntVar> observations, @DeboxedName("lambda1") final RealVar lambda1, @DeboxedName("lambda2") final RealVar lambda2, @DeboxedName("pi") final Simplex pi) {
    this.observations = observations;
    this.lambda1 = lambda1;
    this.lambda2 = lambda2;
    this.pi = pi;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    { // Code generated by: pi ~ SymmetricDirichlet(2, 1)
      // Construction and addition of the factor/model:
      components.add(
        new blang.distributions.SymmetricDirichlet(
          $generated__0(observations, lambda1, lambda2, pi), 
          new $generated__1_class(), 
          new $generated__2_class()
        )
        );
    }
    { // Code generated by: lambda1 ~ Exponential(1.0/2.0)
      // Construction and addition of the factor/model:
      components.add(
        new blang.distributions.Exponential(
          $generated__3(observations, lambda1, lambda2, pi), 
          new $generated__4_class()
        )
        );
    }
    { // Code generated by: lambda2 ~ Exponential(1.0/9.0)
      // Construction and addition of the factor/model:
      components.add(
        new blang.distributions.Exponential(
          $generated__5(observations, lambda1, lambda2, pi), 
          new $generated__6_class()
        )
        );
    }
    for (int i : $generated__7(observations, lambda1, lambda2, pi)) {
      { // Code generated by: observations.get(i) | pi, lambda1, lambda2 ~ IntMixtureExample( pi, #[ Poisson::distribution(lambda1), Poisson::distribution(lambda2) ] )
        // Construction and addition of the factor/model:
        components.add(
          new jss.others.IntMixtureExample(
            $generated__8(i, observations, lambda1, lambda2, pi), 
            new $generated__9_class(pi, lambda1, lambda2), 
            new $generated__10_class(pi, lambda1, lambda2)
          )
          );
      }
    }
    
    return components;
  }
}
