package jss.perm;

import blang.core.DeboxedName;
import blang.core.Model;
import blang.core.ModelBuilder;
import blang.core.ModelComponent;
import blang.core.RealVar;
import blang.inits.Arg;
import blang.inits.DesignatedConstructor;
import blang.types.StaticUtils;
import ca.ubc.stat.blang.StaticJavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

@SuppressWarnings("all")
public class CompositeModel implements Model {
  public static class Builder implements ModelBuilder {
    private boolean fromCommandLine = false;
    
    @Arg
    public Optional<List<RealVar>> y;
    
    public CompositeModel.Builder setY(final List<RealVar> y) {
      // work around typeRef(..) limitation
      Optional<List<RealVar>> $generated__dummy = null;
      this.y = Optional.of(y);
      return this;
    }
    
    @Arg
    public Optional<Permutation> permutation;
    
    public CompositeModel.Builder setPermutation(final Permutation permutation) {
      // work around typeRef(..) limitation
      Optional<Permutation> $generated__dummy = null;
      this.permutation = Optional.of(permutation);
      return this;
    }
    
    public CompositeModel build() {
      // For each optional type, either get the value, or evaluate the ?: expression
      List<RealVar> y;
      if (this.y != null && this.y.isPresent()) {
        y = this.y.get();
      } else {
        y = $generated__5();
      }
      final List<RealVar> __y = y;
      Permutation permutation;
      if (this.permutation != null && this.permutation.isPresent()) {
        permutation = this.permutation.get();
      } else {
        permutation = $generated__6(y);
      }
      final Permutation __permutation = permutation;
      // Build the instance after boxing params
      return new CompositeModel(
        __y, 
        __permutation
      );
    }
  }
  
  @DesignatedConstructor
  public static CompositeModel.Builder builderFromCommandLine() {
    Builder result = new Builder();
    result.fromCommandLine = true;
    return result;
  }
  
  private final List<RealVar> y;
  
  public List<RealVar> getY() {
    return y;
  }
  
  private final Permutation permutation;
  
  public Permutation getPermutation() {
    return permutation;
  }
  
  /**
   * Utility main method for posterior inference on this model
   */
  public static void main(final String[] arguments) {
    StaticJavaUtils.callRunner(Builder.class, arguments);
  }
  
  /**
   * Auxiliary method generated to translate:
   * permutation
   */
  private static Permutation $generated__0(final List<RealVar> y, final Permutation permutation) {
    return permutation;
  }
  
  /**
   * Auxiliary method generated to translate:
   * 0 ..< y.size
   */
  private static Iterable<Integer> $generated__1(final List<RealVar> y, final Permutation permutation) {
    int _size = y.size();
    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
    return _doubleDotLessThan;
  }
  
  /**
   * Auxiliary method generated to translate:
   * y.get(i)
   */
  private static RealVar $generated__2(final int i, final List<RealVar> y, final Permutation permutation) {
    RealVar _get = y.get(i);
    return _get;
  }
  
  /**
   * Auxiliary method generated to translate:
   * permutation.getConnections.get(i)
   */
  private static RealVar $generated__3(final Permutation permutation, final int i) {
    Integer _get = permutation.getConnections().get(i);
    return new blang.core.RealConstant(_get);
  }
  
  public static class $generated__3_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__3(permutation, i);
    }
    
    public String toString() {
      return "permutation.getConnections.get(i)";
    }
    
    private final Permutation permutation;
    
    private final int i;
    
    public $generated__3_class(final Permutation permutation, final int i) {
      this.permutation = permutation;
      this.i = i;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * 0.3
   */
  private static RealVar $generated__4(final Permutation permutation, final int i) {
    return new blang.core.RealConstant(0.3);
  }
  
  public static class $generated__4_class implements Supplier<RealVar> {
    public RealVar get() {
      return $generated__4(permutation, i);
    }
    
    public String toString() {
      return "0.3";
    }
    
    private final Permutation permutation;
    
    private final int i;
    
    public $generated__4_class(final Permutation permutation, final int i) {
      this.permutation = permutation;
      this.i = i;
    }
  }
  
  /**
   * Auxiliary method generated to translate:
   * fixedRealList(2.1,-0.3,0.8)
   */
  private static List<RealVar> $generated__5() {
    List<RealVar> _fixedRealList = StaticUtils.fixedRealList(2.1, (-0.3), 0.8);
    return _fixedRealList;
  }
  
  /**
   * Auxiliary method generated to translate:
   * new Permutation(y.size)
   */
  private static Permutation $generated__6(final List<RealVar> y) {
    int _size = y.size();
    Permutation _permutation = new Permutation(_size);
    return _permutation;
  }
  
  /**
   * Note: the generated code has the following properties used at runtime:
   *   - all arguments are annotated with a BlangVariable annotation
   *   - params additionally have a Param annotation
   *   - the order of the arguments is as follows:
   *     - first, all the random variables in the order they occur in the blang file
   *     - second, all the params in the order they occur in the blang file
   * 
   */
  public CompositeModel(@DeboxedName("y") final List<RealVar> y, @DeboxedName("permutation") final Permutation permutation) {
    this.y = y;
    this.permutation = permutation;
  }
  
  /**
   * A component can be either a distribution, support constraint, or another model  
   * which recursively defines additional components.
   */
  public Collection<ModelComponent> components() {
    ArrayList<ModelComponent> components = new ArrayList();
    
    { // Code generated by: permutation ~ UniformPermutation
      // Construction and addition of the factor/model:
      components.add(
        new jss.perm.UniformPermutation(
          $generated__0(y, permutation)
        )
        );
    }
    for (int i : $generated__1(y, permutation)) {
      { // Code generated by: y.get(i) | permutation, i ~ Normal(permutation.getConnections.get(i), 0.3)
        // Construction and addition of the factor/model:
        components.add(
          new blang.distributions.Normal(
            $generated__2(i, y, permutation), 
            new $generated__3_class(permutation, i), 
            new $generated__4_class(permutation, i)
          )
          );
      }
    }
    
    return components;
  }
}
