# HighFrequencyCovariance.jl

| Build | Coverage | Documentation |
|-------|----------|---------------|
| [![Build status](https://github.com/s-baumann/HighFrequencyCovariance.jl/workflows/CI/badge.svg)](https://github.com/s-baumann/HighFrequencyCovariance.jl/actions) | [![codecov](https://codecov.io/gh/s-baumann/HighFrequencyCovariance.jl/branch/main/graph/badge.svg?token=sElLVJgRel)](https://codecov.io/gh/s-baumann/HighFrequencyCovariance.jl) | [![docs-latest-img](https://img.shields.io/badge/docs-latest-blue.svg)](https://s-baumann.github.io/HighFrequencyCovariance.jl/dev/index.html) |

This package offers a number of algorithms for the calculations of volatilities, correlation matrices and covariance matrices. Covariances can be calculated using the simple method, a multivariate kernel method, a spectral covariance method, preaveraging of returns and finally by exploiting differences in the volatility of different composition series (generated by adding two observed series).

A number of regularisation algorithms are also implemented including eigenvalue cleaning, mixing with the identity matrix, mapping to the nearest PSD (Positive Semi Definite) matrix and mapping to the nearest valid covariance matrix.

For a paper describing the capabilities of this package see [here](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3786912). For a JuliaCon 2021 talk giving an overview of the package click [here](https://www.youtube.com/watch?v=X_TCI02rgu0)
