### horizontal bar graph
reset session

set terminal postscript color portrait font "Helvetica,11"
set output "linear_pip.eps"

$Data << EOD
BlackMkt	0.157	0.191115
SDBlackMkt	0.031	0.045535
NotEquipInv	0.431	0.423625
EquipInv	0.942	0.92494
ExchRateDist	0.06	0.076995
Fr\\\_ForeignLan	0.047	0.06424
Fr\\\_EnglishLan	0.047	0.087435
CivilLiberty	0.1	0.125265
PoliticalRights	0.069	0.088225
Revolution	0.017	0.027485
PublEdupct	0.016	0.038265
HighEnrollment	0.024	0.04551
SizeLabForce	0.047	0.072245
WorkPop	0.024	0.04553
Growth\\\_pop	0.022	0.03307
RuleofLaw	0.516	0.504715
Fr\\\_Protestants	0.461	0.44944
PrimaryExport	0.071	0.097605
Fr\\\_Muslim	0.656	0.610245
Fr\\\_Jewish	0.019	0.033845
Fr\\\_Hindu	0.097	0.117665
EthnoLingFract	0.035	0.061225
Fr\\\_Confucian	0.995	0.99035
Fr\\\_Catholic	0.11	0.127925
Fr\\\_Buddhist	0.167	0.201545
Age	0.058	0.09003
YrsOpenEco	0.502	0.476425
DegreeCapital	0.471	0.4728
Fr\\\_Mining	0.441	0.462045
GDP60	1	0.9974
LifeExpectancy	0.946	0.92036
PrScEnrollment	0.184	0.20025
Area	0.016	0.03189
OutwarOrient	0.021	0.032645
SubSahara	0.757	0.772385
LatinAmerica	0.19	0.22889
War	0.052	0.09076
BritishColony	0.022	0.03489
FrenchColony	0.031	0.049115
SpanishColony	0.034	0.056605
AbsoluteLat	0.024	0.047475

EOD


set yrange [0:*]      # start at zero, find max from the data
set xrange [0:1]
set style fill solid  # solid color boxes
set key outside        # turn off all titles
#unset border
set border 3

set xlabel "Posterior Probability of Inclusion (PIP)"
set ylabel "Covariates"

myBoxWidth = 0.4
set offsets 0,0,0.5-myBoxWidth/2.,0.5
set ytics font "Helvetica, 11" nomirror #scale 0
set xtics  0,0.2,1 nomirror #scale 0

plot $Data using 2:0:(0):2:($0+0.25-myBoxWidth/4.):($0+0.25+myBoxWidth/4.):(0):ytic(1) with boxxyerror lc "#777777" title "benckmark", \
	 $Data using 3:0:(0):3:($0-0.1-myBoxWidth/4.):($0-0.1+myBoxWidth/4.) with boxxyerror lc "#bbbbbb" title "ParMA"


# plot $Data using 2:0:(0):2:($0-myBoxWidth/4.):($0+myBoxWidth/4.):0:ytic(1) with boxxyerror lc "#777777"

### end of code
