// Copyright (C) 2008-2016 National ICT Australia (NICTA)
// 
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// -------------------------------------------------------------------
// 
// Written by Conrad Sanderson - http://conradsanderson.id.au


#ifndef ARMA_INCLUDES
#define ARMA_INCLUDES


#include <cstdlib>
#include <cstring>
#include <climits>
#include <cmath>
#include <ctime>
#include <cstdio>

#include <iostream>
#include <fstream>
#include <sstream>
#include <stdexcept>
#include <new>
#include <limits>
#include <algorithm>
#include <complex>
#include <vector>
#include <utility>


#if ( defined(__unix__) || defined(__unix) || defined(_POSIX_C_SOURCE) || (defined(__APPLE__) && defined(__MACH__)) ) && !defined(_WIN32)
  #include <unistd.h>
#endif


#if (defined(_POSIX_C_SOURCE) && (_POSIX_C_SOURCE >= 200112L))
  #include <sys/time.h>
#endif


#if (__cplusplus >= 201103L)
  #undef  ARMA_USE_CXX11
  #define ARMA_USE_CXX11
#endif


#include "armadillo_bits/config.hpp"
#include "armadillo_bits/compiler_setup.hpp"


#if defined(ARMA_USE_CXX11)
  #include <initializer_list>
  #include <cstdint>
  #include <random>
  #include <functional>
  #include <chrono>
#endif


#if defined(ARMA_USE_TBB_ALLOC)
  #include <tbb/scalable_allocator.h>
#endif


#if defined(ARMA_USE_MKL_ALLOC)
  #include <mkl_service.h>
#endif


#if !defined(ARMA_USE_CXX11)
  #if defined(ARMA_HAVE_TR1)
    #include <tr1/cmath>
    #include <tr1/complex>
  #endif
#endif


#include "armadillo_bits/include_atlas.hpp"
#include "armadillo_bits/include_hdf5.hpp"
#include "armadillo_bits/include_superlu.hpp"


#if defined(_OPENMP)
  #include <omp.h>
#endif



//! \namespace arma namespace for Armadillo classes and functions
namespace arma
  {
  
  // preliminaries
  
  #include "armadillo_bits/arma_forward.hpp"
  #include "armadillo_bits/arma_static_check.hpp"
  #include "armadillo_bits/typedef_elem.hpp"
  #include "armadillo_bits/typedef_elem_check.hpp"
  #include "armadillo_bits/typedef_mat.hpp"
  #include "armadillo_bits/arma_str.hpp"
  #include "armadillo_bits/arma_version.hpp"
  #include "armadillo_bits/arma_config.hpp"
  #include "armadillo_bits/traits.hpp"
  #include "armadillo_bits/promote_type.hpp"
  #include "armadillo_bits/upgrade_val.hpp"
  #include "armadillo_bits/restrictors.hpp"
  #include "armadillo_bits/access.hpp"
  #include "armadillo_bits/span.hpp"
  #include "armadillo_bits/distr_param.hpp"
  #include "armadillo_bits/constants.hpp"
  #include "armadillo_bits/constants_old.hpp"
  
  #ifdef ARMA_RNG_ALT
    #include ARMA_INCFILE_WRAP(ARMA_RNG_ALT)
  #else
    #include "armadillo_bits/arma_rng_cxx98.hpp"
  #endif
  
  #include "armadillo_bits/arma_rng_cxx11.hpp"
  #include "armadillo_bits/arma_rng.hpp"
  
  
  //
  // class prototypes
  
  #include "armadillo_bits/Base_bones.hpp"
  #include "armadillo_bits/BaseCube_bones.hpp"
  #include "armadillo_bits/SpBase_bones.hpp"
  
  #include "armadillo_bits/def_blas.hpp"
  #include "armadillo_bits/def_lapack.hpp"
  #include "armadillo_bits/def_atlas.hpp"
  #include "armadillo_bits/def_arpack.hpp"
  #include "armadillo_bits/def_superlu.hpp"
  #include "armadillo_bits/def_hdf5.hpp"
  
  #include "armadillo_bits/wrapper_blas.hpp"
  #include "armadillo_bits/wrapper_lapack.hpp"
  #include "armadillo_bits/wrapper_atlas.hpp"
  #include "armadillo_bits/wrapper_arpack.hpp"
  #include "armadillo_bits/wrapper_superlu.hpp"
  
  #include "armadillo_bits/cond_rel_bones.hpp"
  #include "armadillo_bits/arrayops_bones.hpp"
  #include "armadillo_bits/podarray_bones.hpp"
  #include "armadillo_bits/auxlib_bones.hpp"
  #include "armadillo_bits/sp_auxlib_bones.hpp"
  
  #include "armadillo_bits/injector_bones.hpp"
  
  #include "armadillo_bits/Mat_bones.hpp"
  #include "armadillo_bits/Col_bones.hpp"
  #include "armadillo_bits/Row_bones.hpp"
  #include "armadillo_bits/Cube_bones.hpp"
  #include "armadillo_bits/xvec_htrans_bones.hpp"
  #include "armadillo_bits/xtrans_mat_bones.hpp"
  #include "armadillo_bits/SizeMat_bones.hpp"
  #include "armadillo_bits/SizeCube_bones.hpp"
    
  #include "armadillo_bits/SpValProxy_bones.hpp"
  #include "armadillo_bits/SpMat_bones.hpp"
  #include "armadillo_bits/SpCol_bones.hpp"
  #include "armadillo_bits/SpRow_bones.hpp"
  #include "armadillo_bits/SpSubview_bones.hpp"
  #include "armadillo_bits/spdiagview_bones.hpp"
  
  #include "armadillo_bits/typedef_mat_fixed.hpp"
  
  #include "armadillo_bits/field_bones.hpp"
  #include "armadillo_bits/subview_bones.hpp"
  #include "armadillo_bits/subview_elem1_bones.hpp"
  #include "armadillo_bits/subview_elem2_bones.hpp"
  #include "armadillo_bits/subview_field_bones.hpp"
  #include "armadillo_bits/subview_cube_bones.hpp"
  #include "armadillo_bits/diagview_bones.hpp"
  #include "armadillo_bits/subview_each_bones.hpp"
  #include "armadillo_bits/subview_cube_each_bones.hpp"
  
  
  #include "armadillo_bits/diskio_bones.hpp"
  #include "armadillo_bits/wall_clock_bones.hpp"
  #include "armadillo_bits/running_stat_bones.hpp"
  #include "armadillo_bits/running_stat_vec_bones.hpp"
  
  #include "armadillo_bits/Op_bones.hpp"
  #include "armadillo_bits/OpCube_bones.hpp"
  #include "armadillo_bits/SpOp_bones.hpp"
  
  #include "armadillo_bits/eOp_bones.hpp"
  #include "armadillo_bits/eOpCube_bones.hpp"
  
  #include "armadillo_bits/mtOp_bones.hpp"
  #include "armadillo_bits/mtOpCube_bones.hpp"
  #include "armadillo_bits/mtSpOp_bones.hpp"
  
  #include "armadillo_bits/Glue_bones.hpp"
  #include "armadillo_bits/eGlue_bones.hpp"
  #include "armadillo_bits/mtGlue_bones.hpp"
  #include "armadillo_bits/SpGlue_bones.hpp"
  
  #include "armadillo_bits/GlueCube_bones.hpp"
  #include "armadillo_bits/eGlueCube_bones.hpp"
  #include "armadillo_bits/mtGlueCube_bones.hpp"
  
  #include "armadillo_bits/eop_core_bones.hpp"
  #include "armadillo_bits/eglue_core_bones.hpp"
  
  #include "armadillo_bits/GenSpecialiser.hpp"
  #include "armadillo_bits/Gen_bones.hpp"
  #include "armadillo_bits/GenCube_bones.hpp"
  
  #include "armadillo_bits/op_diagmat_bones.hpp"
  #include "armadillo_bits/op_diagvec_bones.hpp"
  #include "armadillo_bits/op_dot_bones.hpp"
  #include "armadillo_bits/op_inv_bones.hpp"
  #include "armadillo_bits/op_htrans_bones.hpp"
  #include "armadillo_bits/op_max_bones.hpp"
  #include "armadillo_bits/op_min_bones.hpp"
  #include "armadillo_bits/op_index_max_bones.hpp"
  #include "armadillo_bits/op_index_min_bones.hpp"
  #include "armadillo_bits/op_mean_bones.hpp"
  #include "armadillo_bits/op_median_bones.hpp"
  #include "armadillo_bits/op_sort_bones.hpp"
  #include "armadillo_bits/op_sort_index_bones.hpp"
  #include "armadillo_bits/op_sum_bones.hpp"
  #include "armadillo_bits/op_stddev_bones.hpp"
  #include "armadillo_bits/op_strans_bones.hpp"
  #include "armadillo_bits/op_var_bones.hpp"
  #include "armadillo_bits/op_repmat_bones.hpp"
  #include "armadillo_bits/op_reshape_bones.hpp"
  #include "armadillo_bits/op_vectorise_bones.hpp"
  #include "armadillo_bits/op_resize_bones.hpp"
  #include "armadillo_bits/op_cov_bones.hpp"
  #include "armadillo_bits/op_cor_bones.hpp"
  #include "armadillo_bits/op_shift_bones.hpp"
  #include "armadillo_bits/op_shuffle_bones.hpp"
  #include "armadillo_bits/op_prod_bones.hpp"
  #include "armadillo_bits/op_pinv_bones.hpp"
  #include "armadillo_bits/op_dotext_bones.hpp"
  #include "armadillo_bits/op_flip_bones.hpp"
  #include "armadillo_bits/op_princomp_bones.hpp"
  #include "armadillo_bits/op_misc_bones.hpp"
  #include "armadillo_bits/op_orth_null_bones.hpp"
  #include "armadillo_bits/op_relational_bones.hpp"
  #include "armadillo_bits/op_find_bones.hpp"
  #include "armadillo_bits/op_find_unique_bones.hpp"
  #include "armadillo_bits/op_chol_bones.hpp"
  #include "armadillo_bits/op_cx_scalar_bones.hpp"
  #include "armadillo_bits/op_trimat_bones.hpp"
  #include "armadillo_bits/op_cumsum_bones.hpp"
  #include "armadillo_bits/op_cumprod_bones.hpp"
  #include "armadillo_bits/op_symmat_bones.hpp"
  #include "armadillo_bits/op_hist_bones.hpp"
  #include "armadillo_bits/op_unique_bones.hpp"
  #include "armadillo_bits/op_toeplitz_bones.hpp"
  #include "armadillo_bits/op_fft_bones.hpp"
  #include "armadillo_bits/op_any_bones.hpp"
  #include "armadillo_bits/op_all_bones.hpp"
  #include "armadillo_bits/op_normalise_bones.hpp"
  #include "armadillo_bits/op_clamp_bones.hpp"
  #include "armadillo_bits/op_expmat_bones.hpp"
  #include "armadillo_bits/op_nonzeros_bones.hpp"
  #include "armadillo_bits/op_diff_bones.hpp"
  #include "armadillo_bits/op_norm_bones.hpp"
  #include "armadillo_bits/op_sqrtmat_bones.hpp"
  #include "armadillo_bits/op_logmat_bones.hpp"
  
  #include "armadillo_bits/glue_times_bones.hpp"
  #include "armadillo_bits/glue_mixed_bones.hpp"
  #include "armadillo_bits/glue_cov_bones.hpp"
  #include "armadillo_bits/glue_cor_bones.hpp"
  #include "armadillo_bits/glue_kron_bones.hpp"
  #include "armadillo_bits/glue_cross_bones.hpp"
  #include "armadillo_bits/glue_join_bones.hpp"
  #include "armadillo_bits/glue_relational_bones.hpp"
  #include "armadillo_bits/glue_solve_bones.hpp"
  #include "armadillo_bits/glue_conv_bones.hpp"
  #include "armadillo_bits/glue_toeplitz_bones.hpp"
  #include "armadillo_bits/glue_hist_bones.hpp"
  #include "armadillo_bits/glue_histc_bones.hpp"
  #include "armadillo_bits/glue_max_bones.hpp"
  #include "armadillo_bits/glue_min_bones.hpp"
  #include "armadillo_bits/glue_trapz_bones.hpp"
  #include "armadillo_bits/glue_atan2_bones.hpp"
  #include "armadillo_bits/glue_hypot_bones.hpp"
  
  #include "armadillo_bits/gmm_misc_bones.hpp"
  #include "armadillo_bits/gmm_diag_bones.hpp"
  
  #include "armadillo_bits/spop_max_bones.hpp"
  #include "armadillo_bits/spop_min_bones.hpp"
  #include "armadillo_bits/spop_sum_bones.hpp"
  #include "armadillo_bits/spop_strans_bones.hpp"
  #include "armadillo_bits/spop_htrans_bones.hpp"
  #include "armadillo_bits/spop_misc_bones.hpp"
  #include "armadillo_bits/spop_diagmat_bones.hpp"
  #include "armadillo_bits/spop_mean_bones.hpp"
  #include "armadillo_bits/spop_var_bones.hpp"
  
  #include "armadillo_bits/spglue_plus_bones.hpp"
  #include "armadillo_bits/spglue_minus_bones.hpp"
  #include "armadillo_bits/spglue_times_bones.hpp"
  #include "armadillo_bits/spglue_join_bones.hpp"
  
  #if defined(ARMA_USE_NEWARP)
    #include "armadillo_bits/newarp_EigsSelect.hpp"
    #include "armadillo_bits/newarp_DenseGenMatProd_bones.hpp"
    #include "armadillo_bits/newarp_SparseGenMatProd_bones.hpp"
    #include "armadillo_bits/newarp_DoubleShiftQR_bones.hpp"
    #include "armadillo_bits/newarp_GenEigsSolver_bones.hpp"
    #include "armadillo_bits/newarp_SymEigsSolver_bones.hpp"
    #include "armadillo_bits/newarp_TridiagEigen_bones.hpp"
    #include "armadillo_bits/newarp_UpperHessenbergEigen_bones.hpp"
    #include "armadillo_bits/newarp_UpperHessenbergQR_bones.hpp"
  #endif
  
  
  //
  // low-level debugging and memory handling functions
  
  #include "armadillo_bits/debug.hpp"
  #include "armadillo_bits/memory.hpp"
  
  //
  // wrappers for various cmath functions
  
  #include "armadillo_bits/arma_cmath.hpp"
  
  //
  // classes that underlay metaprogramming 
  
  #include "armadillo_bits/unwrap.hpp"
  #include "armadillo_bits/unwrap_cube.hpp"
  #include "armadillo_bits/unwrap_spmat.hpp"
  
  #include "armadillo_bits/Proxy.hpp"
  #include "armadillo_bits/ProxyCube.hpp"
  #include "armadillo_bits/SpProxy.hpp"
  
  #include "armadillo_bits/diagmat_proxy.hpp"

  #include "armadillo_bits/strip.hpp"
  
  #include "armadillo_bits/Op_meat.hpp"
  #include "armadillo_bits/OpCube_meat.hpp"
  #include "armadillo_bits/SpOp_meat.hpp"
  
  #include "armadillo_bits/mtOp_meat.hpp"
  #include "armadillo_bits/mtOpCube_meat.hpp"
  #include "armadillo_bits/mtSpOp_meat.hpp"
  
  #include "armadillo_bits/Glue_meat.hpp"
  #include "armadillo_bits/GlueCube_meat.hpp"
  #include "armadillo_bits/SpGlue_meat.hpp"
  
  #include "armadillo_bits/eop_aux.hpp"
  
  #include "armadillo_bits/eOp_meat.hpp"
  #include "armadillo_bits/eOpCube_meat.hpp"
  
  #include "armadillo_bits/eGlue_meat.hpp"
  #include "armadillo_bits/eGlueCube_meat.hpp"

  #include "armadillo_bits/mtGlue_meat.hpp"
  #include "armadillo_bits/mtGlueCube_meat.hpp"
  
  #include "armadillo_bits/Base_meat.hpp"
  #include "armadillo_bits/BaseCube_meat.hpp"
  #include "armadillo_bits/SpBase_meat.hpp"
  
  #include "armadillo_bits/Gen_meat.hpp"
  #include "armadillo_bits/GenCube_meat.hpp"
  
  //
  // ostream
  
  #include "armadillo_bits/arma_ostream_bones.hpp"
  #include "armadillo_bits/arma_ostream_meat.hpp"
  
  //
  // n_unique, which is used by some sparse operators

  #include "armadillo_bits/fn_n_unique.hpp"
  
  //
  // operators
  
  #include "armadillo_bits/operator_plus.hpp"
  #include "armadillo_bits/operator_minus.hpp"
  #include "armadillo_bits/operator_times.hpp"
  #include "armadillo_bits/operator_schur.hpp"
  #include "armadillo_bits/operator_div.hpp"
  #include "armadillo_bits/operator_relational.hpp"
  
  #include "armadillo_bits/operator_cube_plus.hpp"
  #include "armadillo_bits/operator_cube_minus.hpp"
  #include "armadillo_bits/operator_cube_times.hpp"
  #include "armadillo_bits/operator_cube_schur.hpp"
  #include "armadillo_bits/operator_cube_div.hpp"
  #include "armadillo_bits/operator_cube_relational.hpp"
  
  #include "armadillo_bits/operator_ostream.hpp"
  
  //
  // user accessible functions
  
  // the order of the fn_*.hpp include files matters,
  // as some files require functionality given in preceding files
  
  #include "armadillo_bits/fn_conv_to.hpp"
  #include "armadillo_bits/fn_max.hpp"
  #include "armadillo_bits/fn_min.hpp"
  #include "armadillo_bits/fn_index_max.hpp"
  #include "armadillo_bits/fn_index_min.hpp"
  #include "armadillo_bits/fn_accu.hpp"
  #include "armadillo_bits/fn_sum.hpp"
  #include "armadillo_bits/fn_diagmat.hpp"
  #include "armadillo_bits/fn_diagvec.hpp"
  #include "armadillo_bits/fn_inv.hpp"
  #include "armadillo_bits/fn_trace.hpp"
  #include "armadillo_bits/fn_trans.hpp"
  #include "armadillo_bits/fn_det.hpp"
  #include "armadillo_bits/fn_log_det.hpp"
  #include "armadillo_bits/fn_eig_gen.hpp"
  #include "armadillo_bits/fn_eig_sym.hpp"
  #include "armadillo_bits/fn_eig_pair.hpp"
  #include "armadillo_bits/fn_lu.hpp"
  #include "armadillo_bits/fn_zeros.hpp"
  #include "armadillo_bits/fn_ones.hpp"
  #include "armadillo_bits/fn_eye.hpp"
  #include "armadillo_bits/fn_misc.hpp"
  #include "armadillo_bits/fn_orth_null.hpp"
  #include "armadillo_bits/fn_regspace.hpp"
  #include "armadillo_bits/fn_find.hpp"
  #include "armadillo_bits/fn_find_unique.hpp"
  #include "armadillo_bits/fn_elem.hpp"
  #include "armadillo_bits/fn_approx_equal.hpp"
  #include "armadillo_bits/fn_norm.hpp"
  #include "armadillo_bits/fn_dot.hpp"
  #include "armadillo_bits/fn_randu.hpp"
  #include "armadillo_bits/fn_randn.hpp"
  #include "armadillo_bits/fn_trig.hpp"
  #include "armadillo_bits/fn_mean.hpp"
  #include "armadillo_bits/fn_median.hpp"
  #include "armadillo_bits/fn_stddev.hpp"
  #include "armadillo_bits/fn_var.hpp"
  #include "armadillo_bits/fn_sort.hpp"
  #include "armadillo_bits/fn_sort_index.hpp"
  #include "armadillo_bits/fn_strans.hpp"
  #include "armadillo_bits/fn_chol.hpp"
  #include "armadillo_bits/fn_qr.hpp"
  #include "armadillo_bits/fn_svd.hpp"
  #include "armadillo_bits/fn_solve.hpp"
  #include "armadillo_bits/fn_repmat.hpp"
  #include "armadillo_bits/fn_reshape.hpp"
  #include "armadillo_bits/fn_vectorise.hpp"
  #include "armadillo_bits/fn_resize.hpp"
  #include "armadillo_bits/fn_cov.hpp"
  #include "armadillo_bits/fn_cor.hpp"
  #include "armadillo_bits/fn_shift.hpp"
  #include "armadillo_bits/fn_shuffle.hpp"
  #include "armadillo_bits/fn_prod.hpp"
  #include "armadillo_bits/fn_eps.hpp"
  #include "armadillo_bits/fn_pinv.hpp"
  #include "armadillo_bits/fn_rank.hpp"
  #include "armadillo_bits/fn_kron.hpp"
  #include "armadillo_bits/fn_flip.hpp"
  #include "armadillo_bits/fn_as_scalar.hpp"
  #include "armadillo_bits/fn_princomp.hpp"
  #include "armadillo_bits/fn_cross.hpp"
  #include "armadillo_bits/fn_join.hpp"
  #include "armadillo_bits/fn_conv.hpp"
  #include "armadillo_bits/fn_trunc_exp.hpp"
  #include "armadillo_bits/fn_trunc_log.hpp"
  #include "armadillo_bits/fn_toeplitz.hpp"
  #include "armadillo_bits/fn_trimat.hpp"
  #include "armadillo_bits/fn_cumsum.hpp"
  #include "armadillo_bits/fn_cumprod.hpp"
  #include "armadillo_bits/fn_symmat.hpp"
  #include "armadillo_bits/fn_syl_lyap.hpp"
  #include "armadillo_bits/fn_hist.hpp"
  #include "armadillo_bits/fn_histc.hpp"
  #include "armadillo_bits/fn_unique.hpp"
  #include "armadillo_bits/fn_fft.hpp"
  #include "armadillo_bits/fn_fft2.hpp"
  #include "armadillo_bits/fn_any.hpp"
  #include "armadillo_bits/fn_all.hpp"
  #include "armadillo_bits/fn_size.hpp"
  #include "armadillo_bits/fn_numel.hpp"
  #include "armadillo_bits/fn_inplace_strans.hpp"
  #include "armadillo_bits/fn_inplace_trans.hpp"
  #include "armadillo_bits/fn_randi.hpp"
  #include "armadillo_bits/fn_randg.hpp"
  #include "armadillo_bits/fn_cond.hpp"
  #include "armadillo_bits/fn_normalise.hpp"
  #include "armadillo_bits/fn_clamp.hpp"
  #include "armadillo_bits/fn_expmat.hpp"
  #include "armadillo_bits/fn_nonzeros.hpp"
  #include "armadillo_bits/fn_interp1.hpp"
  #include "armadillo_bits/fn_qz.hpp"
  #include "armadillo_bits/fn_diff.hpp"
  #include "armadillo_bits/fn_schur.hpp"
  #include "armadillo_bits/fn_kmeans.hpp"
  #include "armadillo_bits/fn_sqrtmat.hpp"
  #include "armadillo_bits/fn_logmat.hpp"
  #include "armadillo_bits/fn_trapz.hpp"
  
  #include "armadillo_bits/fn_speye.hpp"
  #include "armadillo_bits/fn_spones.hpp"
  #include "armadillo_bits/fn_sprandn.hpp"
  #include "armadillo_bits/fn_sprandu.hpp"
  #include "armadillo_bits/fn_eigs_sym.hpp"
  #include "armadillo_bits/fn_eigs_gen.hpp"
  #include "armadillo_bits/fn_spsolve.hpp"
  #include "armadillo_bits/fn_svds.hpp"
  
  //
  // misc stuff
  
  #include "armadillo_bits/hdf5_misc.hpp"
  #include "armadillo_bits/fft_engine.hpp"
  
  //
  // classes implementing various forms of dense matrix multiplication
  
  #include "armadillo_bits/mul_gemv.hpp"
  #include "armadillo_bits/mul_gemm.hpp"
  #include "armadillo_bits/mul_gemm_mixed.hpp"
  #include "armadillo_bits/mul_syrk.hpp"
  #include "armadillo_bits/mul_herk.hpp"
  
  //
  // class meat
  
  #include "armadillo_bits/eop_core_meat.hpp"
  #include "armadillo_bits/eglue_core_meat.hpp"
  
  #include "armadillo_bits/cond_rel_meat.hpp"
  #include "armadillo_bits/arrayops_meat.hpp"
  #include "armadillo_bits/podarray_meat.hpp"
  #include "armadillo_bits/auxlib_meat.hpp"
  #include "armadillo_bits/sp_auxlib_meat.hpp"
  
  #include "armadillo_bits/injector_meat.hpp"
  
  #include "armadillo_bits/Mat_meat.hpp"
  #include "armadillo_bits/Col_meat.hpp"
  #include "armadillo_bits/Row_meat.hpp"
  #include "armadillo_bits/Cube_meat.hpp"
  #include "armadillo_bits/xvec_htrans_meat.hpp"
  #include "armadillo_bits/xtrans_mat_meat.hpp"
  #include "armadillo_bits/SizeMat_meat.hpp"
  #include "armadillo_bits/SizeCube_meat.hpp"
  
  #include "armadillo_bits/field_meat.hpp"
  #include "armadillo_bits/subview_meat.hpp"
  #include "armadillo_bits/subview_elem1_meat.hpp"
  #include "armadillo_bits/subview_elem2_meat.hpp"
  #include "armadillo_bits/subview_field_meat.hpp"
  #include "armadillo_bits/subview_cube_meat.hpp"
  #include "armadillo_bits/diagview_meat.hpp"
  #include "armadillo_bits/subview_each_meat.hpp"
  #include "armadillo_bits/subview_cube_each_meat.hpp"

  #include "armadillo_bits/SpValProxy_meat.hpp"
  #include "armadillo_bits/SpMat_meat.hpp"
  #include "armadillo_bits/SpMat_iterators_meat.hpp"
  #include "armadillo_bits/SpCol_meat.hpp"
  #include "armadillo_bits/SpRow_meat.hpp"
  #include "armadillo_bits/SpSubview_meat.hpp"
  #include "armadillo_bits/SpSubview_iterators_meat.hpp"
  #include "armadillo_bits/spdiagview_meat.hpp"
  
  #include "armadillo_bits/diskio_meat.hpp"
  #include "armadillo_bits/wall_clock_meat.hpp"
  #include "armadillo_bits/running_stat_meat.hpp"
  #include "armadillo_bits/running_stat_vec_meat.hpp"
  
  #include "armadillo_bits/op_diagmat_meat.hpp"
  #include "armadillo_bits/op_diagvec_meat.hpp"
  #include "armadillo_bits/op_dot_meat.hpp"
  #include "armadillo_bits/op_inv_meat.hpp"
  #include "armadillo_bits/op_htrans_meat.hpp"
  #include "armadillo_bits/op_max_meat.hpp"
  #include "armadillo_bits/op_index_max_meat.hpp"
  #include "armadillo_bits/op_index_min_meat.hpp"
  #include "armadillo_bits/op_min_meat.hpp"
  #include "armadillo_bits/op_mean_meat.hpp"
  #include "armadillo_bits/op_median_meat.hpp"
  #include "armadillo_bits/op_sort_meat.hpp"
  #include "armadillo_bits/op_sort_index_meat.hpp"
  #include "armadillo_bits/op_sum_meat.hpp"
  #include "armadillo_bits/op_stddev_meat.hpp"
  #include "armadillo_bits/op_strans_meat.hpp"
  #include "armadillo_bits/op_var_meat.hpp"
  #include "armadillo_bits/op_repmat_meat.hpp"
  #include "armadillo_bits/op_reshape_meat.hpp"
  #include "armadillo_bits/op_vectorise_meat.hpp"
  #include "armadillo_bits/op_resize_meat.hpp"
  #include "armadillo_bits/op_cov_meat.hpp"
  #include "armadillo_bits/op_cor_meat.hpp"
  #include "armadillo_bits/op_shift_meat.hpp"
  #include "armadillo_bits/op_shuffle_meat.hpp"
  #include "armadillo_bits/op_prod_meat.hpp"
  #include "armadillo_bits/op_pinv_meat.hpp"
  #include "armadillo_bits/op_dotext_meat.hpp"
  #include "armadillo_bits/op_flip_meat.hpp"
  #include "armadillo_bits/op_princomp_meat.hpp"
  #include "armadillo_bits/op_misc_meat.hpp"
  #include "armadillo_bits/op_orth_null_meat.hpp"
  #include "armadillo_bits/op_relational_meat.hpp"
  #include "armadillo_bits/op_find_meat.hpp"
  #include "armadillo_bits/op_find_unique_meat.hpp"
  #include "armadillo_bits/op_chol_meat.hpp"
  #include "armadillo_bits/op_cx_scalar_meat.hpp"
  #include "armadillo_bits/op_trimat_meat.hpp"
  #include "armadillo_bits/op_cumsum_meat.hpp"
  #include "armadillo_bits/op_cumprod_meat.hpp"
  #include "armadillo_bits/op_symmat_meat.hpp"
  #include "armadillo_bits/op_hist_meat.hpp"
  #include "armadillo_bits/op_unique_meat.hpp"
  #include "armadillo_bits/op_toeplitz_meat.hpp"
  #include "armadillo_bits/op_fft_meat.hpp"
  #include "armadillo_bits/op_any_meat.hpp"
  #include "armadillo_bits/op_all_meat.hpp"
  #include "armadillo_bits/op_normalise_meat.hpp"
  #include "armadillo_bits/op_clamp_meat.hpp"
  #include "armadillo_bits/op_expmat_meat.hpp"
  #include "armadillo_bits/op_nonzeros_meat.hpp"
  #include "armadillo_bits/op_diff_meat.hpp"
  #include "armadillo_bits/op_norm_meat.hpp"
  #include "armadillo_bits/op_sqrtmat_meat.hpp"
  #include "armadillo_bits/op_logmat_meat.hpp"
  
  #include "armadillo_bits/glue_times_meat.hpp"
  #include "armadillo_bits/glue_mixed_meat.hpp"
  #include "armadillo_bits/glue_cov_meat.hpp"
  #include "armadillo_bits/glue_cor_meat.hpp"
  #include "armadillo_bits/glue_kron_meat.hpp"
  #include "armadillo_bits/glue_cross_meat.hpp"
  #include "armadillo_bits/glue_join_meat.hpp"
  #include "armadillo_bits/glue_relational_meat.hpp"
  #include "armadillo_bits/glue_solve_meat.hpp"
  #include "armadillo_bits/glue_conv_meat.hpp"
  #include "armadillo_bits/glue_toeplitz_meat.hpp"
  #include "armadillo_bits/glue_hist_meat.hpp"
  #include "armadillo_bits/glue_histc_meat.hpp"
  #include "armadillo_bits/glue_max_meat.hpp"
  #include "armadillo_bits/glue_min_meat.hpp"
  #include "armadillo_bits/glue_trapz_meat.hpp"
  #include "armadillo_bits/glue_atan2_meat.hpp"
  #include "armadillo_bits/glue_hypot_meat.hpp"
  
  #include "armadillo_bits/gmm_misc_meat.hpp"
  #include "armadillo_bits/gmm_diag_meat.hpp"
  
  #include "armadillo_bits/spop_max_meat.hpp"
  #include "armadillo_bits/spop_min_meat.hpp"
  #include "armadillo_bits/spop_sum_meat.hpp"
  #include "armadillo_bits/spop_strans_meat.hpp"
  #include "armadillo_bits/spop_htrans_meat.hpp"
  #include "armadillo_bits/spop_misc_meat.hpp"
  #include "armadillo_bits/spop_diagmat_meat.hpp"
  #include "armadillo_bits/spop_mean_meat.hpp"
  #include "armadillo_bits/spop_var_meat.hpp"
  
  #include "armadillo_bits/spglue_plus_meat.hpp"
  #include "armadillo_bits/spglue_minus_meat.hpp"
  #include "armadillo_bits/spglue_times_meat.hpp"
  #include "armadillo_bits/spglue_join_meat.hpp"
  
  #if defined(ARMA_USE_NEWARP)
    #include "armadillo_bits/newarp_cx_attrib.hpp"
    #include "armadillo_bits/newarp_SortEigenvalue.hpp"
    #include "armadillo_bits/newarp_DenseGenMatProd_meat.hpp"
    #include "armadillo_bits/newarp_SparseGenMatProd_meat.hpp"
    #include "armadillo_bits/newarp_DoubleShiftQR_meat.hpp"
    #include "armadillo_bits/newarp_GenEigsSolver_meat.hpp"
    #include "armadillo_bits/newarp_SymEigsSolver_meat.hpp"
    #include "armadillo_bits/newarp_TridiagEigen_meat.hpp"
    #include "armadillo_bits/newarp_UpperHessenbergEigen_meat.hpp"
    #include "armadillo_bits/newarp_UpperHessenbergQR_meat.hpp"
  #endif
  }



#include "armadillo_bits/compiler_setup_post.hpp"

#endif
