
library(MLGL)
library(gglasso)
library(fastcluster)


t1 <- proc.time()
for(p in P)
{
  for(rho in RHO)
  {   
    for(l in LL)
    {
      for(K in KK)
      {
        cat("p=",p," rho=",rho," K=",K," sizegr=",l,"\n")        
        
        RESGG = RESHCGG <- list()
        for(sample in 1:nbSample)
        {
          if(sample%%10==0)
            cat("sample ",sample,"\n")
          
          
          load(paste0("data/datan",n,"p",p,"rho",rho,"sizegr",l,"sample",sample,".RData"))
          load(paste0("data/rep1n",n,"p",p,"rho",rho,"K",K,"sizegr",l,"sample",sample,".RData"))
          
          # hcc gglasso
          reshcgg <- MLGL(X, y, hc = cah)
          
          # glasso
          nbGroup <- p - which.max(diff(cah$height))
          group <- cutree(cah, nbGroup)
          groupord <- order(group)
          grouprevord <- order(groupord)
          group2 <- group[groupord]
          
          resgg <- gglasso(X[,groupord], y, group = group2)
          resgg$beta = resgg$beta[grouprevord,]
          resgg$group = resgg$group[grouprevord]
          
          
          
          save(reshcgg, file = paste0("res/HCgglasson",n,"p",p,"rho",rho,"K",K,"sizegr",l,"sample",sample,".RData")) 
          save(resgg, file = paste0("res/gglasson",n,"p",p,"rho",rho,"K",K,"sizegr",l,"sample",sample,".RData")) 
          
          
          
          # hcc gglasso
	  ind <- 1:(n/2)
          reshcgg <- MLGL(X[ind,], y[ind], hc = cah)
          
          # glasso
          nbGroup <- p - which.max(diff(cah$height))
          group <- cutree(cah, nbGroup)
          groupord <- order(group)
          grouprevord <- order(groupord)
          group2 <- group[groupord]
          
          resgg <- gglasso(X[ind, groupord], y[ind], group = group2)
          resgg$beta = resgg$beta[grouprevord,]
          resgg$group = resgg$group[grouprevord]
          
          
          
          save(reshcgg, file = paste0("res/HCgglasso2n",n,"p",p,"rho",rho,"K",K,"sizegr",l,"sample",sample,".RData")) 
          save(resgg, file = paste0("res/gglasso2n",n,"p",p,"rho",rho,"K",K,"sizegr",l,"sample",sample,".RData")) 
          
        }#fin for sample
      }#fin for K
    }#fin for sizegr
  }#fin for RHO
}#fin for P

t2 <- proc.time()
t2-t1
