
library(MASS)
library(fastcluster)



set.seed(42)


for(p in P)
{
  for(rho in RHO)
  {
    for(l in LL)
    {
      cat("p=",p," rho=",rho," L=",l,"\n")
      
      
      taillemoyen <- floor(l)
      taillepetit <- floor(l/2)
      taillegrand <- floor(l*1.5)
      a <- rep(c(taillemoyen, taillepetit, taillegrand), ceiling(p/(3*l))+5)
      aa <- cumsum(a)
      ind <- which(aa >= p)[1]
      indicegr <- aa[1:ind]
      indicegr[ind] = p
      indicegrb <- c(0, indicegr)
      sizegr <- diff(indicegrb)
      Sigma <- matrix(0, nrow = p, ncol = p)
      
      for(i in 1:length(indicegr))
      {
        Sigma[(indicegrb[i]+1):indicegrb[i+1], (indicegrb[i]+1):indicegrb[i+1]] = rho
      }
      diag(Sigma)=1
      
      
      
      
      for(sample in 1:nbSample)
      {
        if(sample%%10 == 0)
          cat("sample ",sample,"\n")
        X <- mvrnorm(n, rep(0, p), Sigma)
        X = scale(X, center = TRUE, scale = FALSE)
        X = scale(X, center = FALSE, scale = sqrt(colSums(X^2)/n))
        
        
        # cah <- MLGL:::bootstrapHclust(X, frac = 1, B = 50, method = metHC, nCore = 4)
        cah <- fastcluster::hclust(dist(t(X)), method="ward.D2")
        
        save(X, cah, sizegr, file = paste0("data/","datan",n,"p",p,"rho",rho,"sizegr",l,"sample",sample,".RData")) 
      }
      
    }
  }
}
