library(gglasso)
library(MLGL)
library(foreach)
library(doParallel)
# n <- 200
# nbSample <- 100
# P <- 500
# K <- c(5, 10)
# L <- c(5, 10)
# RHO <- c(0.9,0.7,0.5)

cl <- parallel::makeCluster(6)
doParallel::registerDoParallel(cl)

cat("------------------------- Kappa -------------------------\n")
for(n in N)
{
  for(p in P)
  {
    for(k in K)
    {
      for(l in L)
      {
        cat(paste0("cadre=",cadre," n=",n," p=",p," k=",k," l=",l,"\n"))
        #      for(rho in RHO)
        a=foreach(rho = RHO, .packages = "MLGL")%dopar%
        {
          
          KGR = KVAR <- matrix(0, nrow = nbSample, ncol = 100)
          temps = rep(0, nbSample)
          
          for(sample in 1:nbSample)
          {
            set.seed(k * 1e7 + l * 1e5 + sample * 10 + rho * 10)
            load(paste0("Cadre",cadre,"/data/datan",n,"p",p,"rho",rho,"l",l,"sample",sample,".RData"))
            load(paste0("Cadre",cadre,"/res/mlgl/mlgln",n,"p",p,"rho",rho,"l",l,"K",k,"sample",sample,".RData"))
            load(paste0("Cadre",cadre,"/rep/repn",n,"p",p,"rho",rho,"l",l,"K",k,"sample",sample,".RData"))
            
            nbgrtot = max(res$structure$group)
            nbvartot = length(res$structure$group)
            ##################################
            t1=proc.time()        
            B=10
            kappavar = matrix(NA, nrow = B, ncol = length(res$lambda))
            kappagr = matrix(NA, nrow = B, ncol = length(res$lambda))
            for(b in 1:B)
            {
              testind1 = sample(1:n, floor(n/2))
              testind2 = (1:n)[-testind1]
              res1 = MLGL(X[testind1,], y[testind1], lambda = res$lamdbda, hc = res$hc)
              res2 = MLGL(X[testind2,], y[testind2], lambda = res$lamdbda, hc = res$hc)
              
              for(indlam in 1:length(res$lambda))
              {
                non01=res1$var[[indlam]]
                non02=res2$var[[indlam]]
                
                non0gr1=unique(res1$group[[indlam]])
                non0gr2=unique(res2$group[[indlam]])
                
                if( ((length(non0gr1)==0) && (length(non0gr2)==0)) || ((length(non0gr1)==nbgrtot) && (length(non0gr2)==nbgrtot)) )
                {
                  kappagr[b,indlam]=-1
                }
                else
                {
                  n11=length(intersect(non0gr1,non0gr2))
                  n12=length(intersect(non0gr1,(1:nbgrtot)[-non0gr2]))
                  n21=length(intersect(non0gr2,(1:nbgrtot)[-non0gr1]))
                  n22=length(intersect((1:nbgrtot)[-non0gr2],(1:nbgrtot)[-non0gr1]))
                  pra=(n11+n22)/nbgrtot
                  pre=(n11+n12)/nbgrtot*(n11+n21)/nbgrtot+(n22+n21)/nbgrtot*(n22+n12)/nbgrtot
                  kappagr[b,indlam]=(pra-pre)/(1-pre)
                }
                
                if( ((length(non01)==0) && (length(non02)==0)) || ((length(non01)==nbvartot) && (length(non02)==nbvartot)) )
                {
                  kappavar[b,indlam]=-1
                }
                else
                {
                  n11=length(intersect(non01,non02))
                  n12=length(intersect(non01,(1:nbvartot)[-non02]))
                  n21=length(intersect(non02,(1:nbvartot)[-non01]))
                  n22=length(intersect((1:nbvartot)[-non02],(1:nbvartot)[-non01]))
                  pra=(n11+n22)/nbvartot
                  pre=(n11+n12)/nbvartot*(n11+n21)/nbvartot+(n22+n21)/nbvartot*(n22+n12)/nbvartot
                  kappavar[b,indlam]=(pra-pre)/(1-pre)
                }
                
              }
              
            }#fin for b
            t2=proc.time()
            
            temps=(t2-t1)[3]     
            
            KVAR[sample,1:ncol(kappavar)] = colMeans(kappavar)
            KGR[sample,1:ncol(kappagr)] = colMeans(kappagr) 
          }#fin for sample
          save(KVAR, KGR, temps, file = paste0("Cadre",cadre,"/res/kappa/kappan",n,"p",p,"rho",rho,"l",l,"K",k,".RData"))
        }#fin for rho
      }#fin for l
      
    }#fin for K
  }#fin for p
}
parallel::stopCluster(cl)
