
suffix <- ifelse(cadre == 3, "pi0.5", "")

for(n in N)
{
  for(p in P)
  {
    for(rho in RHO)
    {   
      for(l in L)
      {
        for(k in K)
        {
          # sel max reject
          INDLAMBDAAOPT <- rep(NA, 100)
          sel <- matrix(nrow = 100, ncol = 2)
          
          for(i in 1:100)
          {
            load(paste0("Cadre",cadre,"/res/mlgl/mlgln",n,"p",p,"rho",rho,"l",l,suffix,"K",k,"sample",i,".RData"))
            load(paste0("Cadre",cadre,"/res/mlgl/mlgltfn",n,"p",p,"rho",rho,"l",l,suffix,"K",k,".RData"))
            
            INDLAMBDAAOPT [i] = indLambdaOpt
            sel[i,] = c(ntrue[i, INDLAMBDAAOPT[i]], nfalse[i, INDLAMBDAAOPT[i]])
          }
          colMeans(sel)
          
          
          # sel max true reject
          selTrueRejectMax <- matrix(nrow = 100, ncol = 2)
          for(sample in 1:100)
          {
            load(paste0("Cadre",cadre,"/res/mlgl/mlgln",n,"p",p,"rho",rho,"l",l,suffix,"K",k,"sample",sample,".RData"))
            
            
            ntrueReject = nfalseReject <- rep(0, 100)
            for(indLambda in 1:100)
            {
              if(length(res$var[[indLambda]])>0)
              {
                indVraiVar <- which(res$var[[indLambda]]%in%trueind)
                var <- res$var[[indLambda]][indVraiVar]
                # numéro de groupe associé aux vraies variables présentes
                gr  <- res$group[[indLambda]][indVraiVar]
                # groupe contenant au moins 1 vraie variable
                tg = unique(gr)      
                # on enlève les groupes contenant plusieurs vraie var
                tg = setdiff(tg,unique(gr[duplicated(gr)]))
                ind = gr%in%tg
                
                allgr = unique(res$group[[indLambda]])
                fg = setdiff(allgr, gr[ind])
                
                ntrueReject[indLambda] = sum(REJECT[[indLambda]]%in%tg)
                nfalseReject[indLambda] = sum(REJECT[[indLambda]]%in%fg)
                
              }
            }# fin for lambda
            
            selTrueRejectMax[sample,] = c(ntrueReject[which.max(ntrueReject)], nfalseReject[which.max(ntrueReject)])
          }
          
          
          
          # kappa
          load(paste0("Cadre",cadre,"/res/kappa/kappan",n,"p",p,"rho",rho,"l",l,suffix,"K",k,".RData"))
          alpha <- 0.05
          
          indLambdaGR <- apply(KGR, 1, function(x) { which(x/max(x) >1 - alpha)[1]})
          
          load(paste0("Cadre",cadre,"/res/mlgl/mlgltfn",n,"p",p,"rho",rho,"l",l,suffix,"K",k,".RData"))
          
          selKappa <- matrix(nrow = 100, ncol = 2)
          for(i in 1:100)
          {
            selKappa[i,] = c(ntrue[i, indLambdaGR[i]], nfalse[i, indLambdaGR[i]])
          }
          colMeans(selKappa)
          
          
          
          # cv
          load(paste0("Cadre",cadre,"/res/5fcv/rescvn",n,"p",p,"rho",rho,"l",l,suffix,"K",k,"sample100.RData"))
          selcv <- matrix(nrow = 100, ncol = 2)
          for(i in 1:100)
          {
            selcv[i,] = c(ntrue[i, indlambdaMin[i]], nfalse[i, indlambdaMin[i]])
          }
          colMeans(selcv)
          
          
          # stab
          selstab <- matrix(nrow = 100, ncol = 2)
          
          for(sample in 1:100)
          {          
            load(paste0("Cadre",cadre,"/res/mlgl/mlgln",n,"p",p,"rho",rho,"l",l,suffix,"K",k,"sample",sample,".RData"))
            load(paste0("Cadre",cadre,"/res/stab/resstabn",n,"p",p,"rho",rho,"l",l,suffix,"K",k,"sample",sample,".RData"))
            
            indTrueGroup <- which(tapply(resstab$var%in%trueind, resstab$group, sum) == 1)
            
            indsel <- which(apply(as.matrix(resstab$stability) > 0.75, 2, any))
            
            selstab[sample, 1] = sum(indsel%in%indTrueGroup)
            selstab[sample, 2] = length(indsel) - selstab[sample, 1]
            
          }#fin for sample
          
          
          out <- rbind(colMeans(sel), 
                       colMeans(selTrueRejectMax),
                       c(mean(ntrueLam), mean(nfalseLam)), 
                       colMeans(selKappa),
                       colMeans(selcv),
                       colMeans(selstab))
          rownames(out) = c("MLGL+lambda_RM", "MLGL+HMT+lambda_TM", "MLGL+HMT+lambda_RM", "MLGL+lambda_kappa", "MLGL+lambda_5fcv", "MLGL stability")
          colnames(out) = c("TP", "FP")
          
          write.table(out, file = paste0("Cadre",cadre,"/res/compSel/compn",n,"p",p,"rho",rho,"l",l,suffix,"K",k,".txt"))
          
        }#fin for K
      }#fin for l
    }#fin for RHO
  }
}

