library(MASS)


for(n in N)
{
  for(p in P)
  {
    for(rho in RHO)
    {   
      for(l in L)
      {
        suffix <- paste0("n",n,"p",p,"rho",rho,"l",l,"pi",round(pi,2))
        
        cat("n=",n," p=",p," rho=",rho," L=",l," pi=",round(pi,2),"\n")
        set.seed(10)
        
        nbgroup = round(p*(1-pi)/l)
        Sigma = diag(p)
        for(i in 1:nbgroup)
        {
          Sigma[(1+l*(i-1)):(l*i), (1+l*(i-1)):(l*i)] = rho
        }
        diag(Sigma) = 1
        
        for(sample in 1:nbSample)
        {
          if(sample%%10==0)
            cat("sample ",sample,"\n")
          X = mvrnorm(n,rep(0,p),Sigma)
          X = scale(X,center=TRUE,scale=FALSE)
          X = scale(X,center=FALSE,scale=sqrt(colSums(X^2)/n))
       
          save(X, file = paste0("Cadre",3,"/data/","data",suffix,"sample",sample,".RData")) 
          
        }#fin for sample
      }#fin for l
    }#fin for RHO
  }#fin for P
}# fin for n
