library(MASS)


for(n in N)
{
  for(p in P)
  {
    for(rho in RHO)
    {   
      for(l in L)
      {
      cat("p=",p," rho=",rho,"l=",l,"\n")
      
      suffix <- paste0("n",n,"p",p,"rho",rho,"rho",rho,"l",l)
      
      nbgroup = floor(p/l)
      
      Sigma = matrix(rho2, nrow = p, ncol = p)
      for(i in 1:nbgroup)
      {
        Sigma[(1+l*(i-1)):(l*i),(1+l*(i-1)):(l*i)] = rho
      }
      diag(Sigma)=1
      
      for(sample in 1:nbSample)
      {
        if(sample%%10 == 0)
          cat("sample ", sample, "\n")
        X = mvrnorm(n, rep(0,p), Sigma)
        X = scale(X, center = TRUE, scale = FALSE)
        X = scale(X, center = FALSE, scale = sqrt(colSums(X^2)/n))

        
        save(X, file = paste0("Cadre",4,"/data/data",suffix,"sample",sample,".RData")) 
        
      }#fin for sample
    }#fin for l
  }#fin for RHO
}#fin for P
}# fin for n
