setwd("methodComparison")

# Parameters --------------------------------------------------------------
set.seed(42)
t1 <- proc.time()
# Number of repetitions
nbSample <- 100

# simulation's framework: 1, 2 or 3
# 1 : groups of the same size
# 2 : groups of different size
# 3 : groups and isolated variables
cadre <- 1

### Common parameters
# Number of individuals # one half is used for the penalized regression, the other is used for the testing procedure
N <- 100 # c(100, 200)
# Number of variables
P <- 500 #c(100, 200)
# group size # L must divide P
L <- c(5, 10)
# within group correlation
RHO <- c(0.5, 0.7, 0.9)

### Cadre 3 : The data contains groups and single variables
# Proportion of single variables
pi <- 0.5 # one value


### Response
# Number of true variables
K <- c(5, 10)
# Signal to noise ratio
SNR <- 2 # one value

# method for hclust
metHC <- "ward.D2"

#
factorSplit <- 1/2

# Clean previous data and results -----------------------------------------

# Simulate data -----------------------------------------------------------

# data
#source(paste0("run/simuCadre", cadre, ".R"))

# AHC
# source("run/runCAH.R")

# Response
# source("run/rep.R")

# data (resp AHC, response) are saved in the Cadre1/data (resp. Cadre1/cah, Cadre1/rep) folder

# Methods ----------------------------------------------------------------
# Multi-Layer Group-Lasso
source("run/runMLGL2.R")

source("run/runHMT.R")

source("run/runtfmlgl2.R")

source("run/kappa.R")

source("run/5fcv.R")

source("run/stab.R")

source("run/printResult2.R")

source("run/printTableResult.R")
t2 <- proc.time()

print(t2-t1)
setwd("..")
