# install required packages if needed
pkgs <- c("dendextend", "pls", "cluster", "glmnet", "MLGL", "doParallel")
for (pkg in pkgs) {
    if (!requireNamespace(pkg, quietly = TRUE)) {
        install.packages(pkg)
    }
}
if (!requireNamespace("standGL", quietly = TRUE)) {
    # this package is archived on CRAN:
    install.packages("https://cran.r-project.org/src/contrib/Archive/standGL/standGL_1.1.tar.gz")
}


library("MLGL")

# run script
source("alpha/compAlpha.R")  # Figure 12
source("compGlasso/run.R")  # Figures 7/8
source("methodComparison/runall.R")
source("methodComparison/runallCompSel.R")
