# Application

Application of MLGL to simulated data and the dataset gasoline from the `pls` package.

This dataset contains NIR spectra and octane numbers of 60 gasoline samples. The NIR spectra were measured using diffuse reflectance as log(1/R) from 900 nm to 1700 nm in 2 nm intervals, giving 401 wavelengths.

## Required packages

```
pkgs <- c("dendextend", "pls", "cluster", "corrplot", "glmnet", "MLGL", "gglasso")
for (pkg in pkgs) {
    if (!requireNamespace(pkg, quietly = TRUE)) {
        install.packages(pkg)
    }
}
if (!requireNamespace("standGL", quietly = TRUE)) {
    # this package is archived on CRAN: 
    install.packages("https://cran.r-project.org/src/contrib/Archive/standGL/standGL_1.1.tar.gz")
}
```

## File

*code.R* runs the analysis of an artificial dataset and gasoline dataset with MLGL, lasso and generates plots used in the article in this folder.

The gasoline plots generated are located in the current directory with the following names: 
Fig 5 : boostrap_50_gasoline_42_average_wide_0.5.pdf
Fig 6 : boostrap_50_corrplot_MLGL_42_average0.5.pdf
Fig 7 : bootstrap_selection_average.pdf
Fig 11 : bootstrap_selected_42_average.pdf

